/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* (c) Copyright 2000 Adobe Systems Incorporated                       */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------------------
//
//	File:
//		PIStringTerminology.h
//
//	(c) Copyright 2000 Adobe Systems Incorporated.
//	All Rights Reserved.
//
//	Distribution:
//		PUBLIC
//
//	Description:
//*****************************************************************************
#ifndef __PIStringTerminology_h__
#define __PIStringTerminology_h__
/*  $Id: //photoshop/6.0/Photoshop/SharedInterfaces/PIStringTerminology.h#139 $  */

//*****************************************************************************

// This file defines constants for the strings used to access descriptor
// events, keys, classes, enum types, and enum values. The name of each symbol is
// the same as the string it represents with "k" prepended and "Str" appended.
// The purpose of using these symbols instead of literal strings is to detect
// misspellings at call sites. 
//
// Check that your new names are unique by searching within UActionsTerminology.r
//
// * All event names must be different from all other event names.
// * All class names must be different from all other class names
// * All enumeration type names must be different from all other enumeration type names
// * All keys must be different from all other keys used in the same class or event.
// * All enumeration values must be different from all other enumeration values
//   in the same enumeration type.
// * A class, event, enumeration type, enumeration value, and a key can all have
//   the same name.
//
// Put generally, the names for things must only be unique within a particular
// category and scope, and in fact you shouldn't make things unique unnecessarily --
// generic terms are preferable, and if there's an existing word for something, use it.
//
// If you need to get the DescType value corresponding to any string, use
// GetStringID (stringValue). This is useful when you need to pass an event
// or other ID to a routine that has only a DescType parameter interface or
// when you have been passed a DescType event, class, etc. value and need
// to compare it against one of these string values.

#define k128BitFloatingPointStr "128BitFloatingPoint"
#define k16BitsPerPixelStr "16BitsPerPixel"
#define k1BitPerPixelStr "1BitPerPixel"
#define k2BitsPerPixelStr "2BitsPerPixel"
#define k32BitsPerPixelStr "32BitsPerPixel"
#define k3DAntiAliasStr "3DAntiAlias"
#define k3DTransformStr "3DTransform"
#define k4BitsPerPixelStr "4BitsPerPixel"
#define k5000Str "5000"
#define k5500Str "5500"
#define k6500Str "6500"
#define k72ColorStr "72Color"
#define k72GrayStr "72Gray"
#define k7500Str "7500"
#define k8BitsPerPixelStr "8BitsPerPixel"
#define k9300Str "9300"
#define kadvancedTIFFStr "advancedTIFF"
#define kAntialiasGlossStr "antialiasGloss"
#define kannotationStr "annotation"
#define kannotSoundStr "annotSound"
#define kannotTextStr "annotText"
#define kannotTypeStr "annotType"
#define kannotUnknownStr "annotUnknown"
#define kaStr "a"
#define kADSBottomsStr "ADSBottoms"
#define kADSCentersHStr "ADSCentersH"
#define kADSCentersVStr "ADSCentersV"
#define kADSHorizontalStr "ADSHorizontal"
#define kADSLeftsStr "ADSLefts"
#define kADSRightsStr "ADSRights"
#define kADSTopsStr "ADSTops"
#define kADSVerticalStr "ADSVertical"
#define kAEListStr "AEList"
#define kAERecordStr "AERecord"
#define kASCIIStr "ASCII"
#define kaboutAppStr "aboutApp"
#define kabsColorimetricStr "absColorimetric"
#define kabsoluteStr "absolute"
#define kaccentedEdgesStr "accentedEdges"
#define kactionStr "action"
#define kactionDataStr "actionData"
#define kactionReferenceStr "actionReference"
#define kactionSetStr "actionSet"
#define kactualPixelsStr "actualPixels"
#define kadaptiveStr "adaptive"
#define kaddStr "add"
#define kaddNoiseStr "addNoise"
#define kaddToStr "addTo"
#define kaddKnotToolStr "addKnotTool"
#define kaddressAttrStr "addressAttr"
#define kadjustmentStr "adjustment"
#define kadjustmentLayerStr "adjustmentLayer"
#define kadjustmentOptionsStr "adjustmentOptions"
#define kadobeRGB1998Str "adobeRGB1998"
#define kairbrushEraserStr "airbrushEraser"
#define kairbrushToolStr "airbrushTool"
#define kaliasStr "alias"
#define kalignStr "align"
#define kalignDistributeSelectorStr "alignDistributeSelector"
#define kalignedStr "aligned"
#define kalignmentStr "alignment"
#define kalignmentTypeStr "alignmentType"
#define kallEnumStr "allEnum"
#define kallStr "all"
#define kallExceptStr "allExcept"
#define kallToolOptionsStr "allToolOptions"
#define kalphaChannelOptionsClassStr "alphaChannelOptionsClass"
#define kalphaChannelOptionsStr "alphaChannelOptions"
#define kalphaChannelsStr "alphaChannels"
#define kaltTagStr "altTag"
#define kambientBrightnessStr "ambientBrightness"
#define kambientColorStr "ambientColor"
#define kamountStr "amount"
#define kamountHighStr "amountHigh"
#define kamountLowStr "amountLow"
#define kamountMediumStr "amountMedium"
#define kamplitudeMaxStr "amplitudeMax"
#define kamplitudeMinStr "amplitudeMin"
#define kanchorStr "anchor"
#define kangleStr "angle"
#define kangle1Str "angle1"
#define kangle2Str "angle2"
#define kangle3Str "angle3"
#define kangle4Str "angle4"
#define kangledStrokesStr "angledStrokes"
#define kangleUnitStr "angleUnit"
#define kantiAliasStr "antiAlias"
#define kantiAliasTypeStr "antiAliasType"
#define kantiAliasCrispStr "antiAliasCrisp"
#define kantiAliasHighStr "antiAliasHigh"
#define kantiAliasLowStr "antiAliasLow"
#define kantiAliasMediumStr "antiAliasMedium"
#define kantiAliasNoneStr "antiAliasNone"
#define kantiAliasSmoothStr "antiAliasSmooth"
#define kantiAliasStrongStr "antiAliasStrong"
#define kantiAliasedPICTAcquireStr "antiAliasedPICTAcquire"
#define kanyStr "any"
#define kAOLPreferencesStr "AOLPreferences"
#define kappParametersStr "appParameters"
#define kappendStr "append"
#define kapplSignatureStr "applSignature"
#define kappleEventStr "appleEvent"
#define kappleRGBStr "appleRGB"
#define kapplicationStr "application"
#define kapplyLockingStr "applyLocking"
#define kapplyStr "apply"
#define kapplyImageEventStr "applyImageEvent"
#define kapplyImageEnumStr "applyImageEnum"
#define kapplyStyleStr "applyStyle"
#define kareaStr "area"
#define kareaSelectorStr "areaSelector"
#define karoundCenterStr "aroundCenter"
#define karrangeStr "arrange"
#define karrowheadStr "arrowhead"
#define kartBrushToolStr "artBrushTool"
#define kassignProfileStr "assignProfile"
#define kasStr "as"
#define kaskStr "ask"
#define kaskMismatchOpeningStr "askMismatchOpening"
#define kaskMismatchPastingStr "askMismatchPasting"
#define kaskMissingStr "askMissing"
#define kaskWhenOpeningStr "askWhenOpening"
#define kassertStr "assert"
#define kassumeOptionsStr "assumeOptions"
#define kassumedCMYKStr "assumedCMYK"
#define kassumedGrayStr "assumedGray"
#define kassumedProfileStr "assumedProfile"
#define kassumedRGBStr "assumedRGB"
#define katStr "at"
#define kauthorNameStr "authorName"
#define kautoStr "auto"
#define kautoContrastStr "autoContrast"
#define kautoEraseStr "autoErase"
#define kautoKernStr "autoKern"
#define kaxisStr "axis"
#define kbStr "b"
#define kbMPFormatStr "bMPFormat"
#define kbackStr "back"
#define kbackgroundStr "background"
#define kbackgroundColorStr "backgroundColor"
#define kbackgroundEraserToolStr "backgroundEraserTool"
#define kbackgroundLayerStr "backgroundLayer"
#define kbackgroundLevelStr "backgroundLevel"
#define kbackwardStr "backward"
#define kbackwardEnumStr "backwardEnum"
#define kbalanceStr "balance"
#define kbasReliefStr "basRelief"
#define kbaselineShiftStr "baselineShift"
#define kbatchSourceTypeStr "batchSourceType"
#define kbatchStr "batch"
#define kbatchFromDropletStr "batchFromDroplet"
#define kbeepWhenDoneStr "beepWhenDone"
#define kbeginRampStr "beginRamp"
#define kbeginSustainStr "beginSustain"
#define kbehindStr "behind"
#define kbelowStr "below"
#define kbestStr "best"
#define kbetterStr "better"
#define kbevelDirectionStr "bevelDirection"
#define kbevelEmbossStr "bevelEmboss"
#define kbevelEmbossStampStyleStr "bevelEmbossStampStyle"
#define kbevelEmbossStyleStr "bevelEmbossStyle"
#define kbevelStyleStr "bevelStyle"
#define kbevelTechniqueStr "bevelTechnique"
#define kbicubicStr "bicubic"
#define kbigNudgeHStr "bigNudgeH"
#define kbigNudgeVStr "bigNudgeV"
#define kbilinearStr "bilinear"
#define kbinaryStr "binary"
#define kbitDepthStr "bitDepth"
#define kbitDepth1Str "bitDepth1"
#define kbitDepth24Str "bitDepth24"
#define kbitDepth4Str "bitDepth4"
#define kbitDepth8Str "bitDepth8"
#define kbitmapStr "bitmap"
#define kbitmapModeStr "bitmapMode"
#define kblackStr "black"
#define kblackAndWhiteStr "blackAndWhite"
#define kblackBodyStr "blackBody"
#define kblackClipStr "blackClip"
#define kblackGenerationStr "blackGeneration"
#define kblackGenerationTypeStr "blackGenerationType"
#define kblackGenerationCurveStr "blackGenerationCurve"
#define kblackIntensityStr "blackIntensity"
#define kblackLevelStr "blackLevel"
#define kblackLimitStr "blackLimit"
#define kblacksStr "blacks"
#define kblastStr "blast"
#define kblendClippedStr "blendClipped"
#define kblendInteriorStr "blendInterior"
#define kbleedStr "bleed"
#define kblendModeStr "blendMode"
#define kblendOptionsStr "blendOptions"
#define kblendRangeStr "blendRange"
#define kblockEraserStr "blockEraser"
#define kblocksStr "blocks"
#define kblueStr "blue"
#define kblueBlackPointStr "blueBlackPoint"
#define kblueGammaStr "blueGamma"
#define kblueWhitePointStr "blueWhitePoint"
#define kblueXStr "blueX"
#define kblueYStr "blueY"
#define kbluesStr "blues"
#define kblurStr "blur"
#define kblurEventStr "blurEvent"
#define kblurMethodStr "blurMethod"
#define kblurMoreStr "blurMore"
#define kblurQualityStr "blurQuality"
#define kblurToolStr "blurTool"
#define kbookStr "book"
#define kbookColorStr "bookColor"
#define kbooleanStr "boolean"
#define kborderStr "border"
#define kborderThicknessStr "borderThickness"
#define kbottomEnumStr "bottomEnum"
#define kbottomRightPixelColorStr "bottomRightPixelColor"
#define kbottomStr "bottom"
#define kbrightnessStr "brightness"
#define kbrightnessEventStr "brightnessEvent"
#define kbrightnessContrastStr "brightnessContrast"
#define kbrushStr "brush"
#define kbrushDarkRoughStr "brushDarkRough"
#define kbrushDetailStr "brushDetail"
#define kbrushLightRoughStr "brushLightRough"
#define kbrushSimpleStr "brushSimple"
#define kbrushSizeStr "brushSize"
#define kbrushSparkleStr "brushSparkle"
#define kbrushTypeStr "brushType"
#define kbrushWideBlurryStr "brushWideBlurry"
#define kbrushWideSharpStr "brushWideSharp"
#define kbrushesStr "brushes"
#define kbrushesAppendStr "brushesAppend"
#define kbrushesDefineStr "brushesDefine"
#define kbrushesDeleteStr "brushesDelete"
#define kbrushesLoadStr "brushesLoad"
#define kbrushesNewStr "brushesNew"
#define kbrushesOptionsStr "brushesOptions"
#define kbrushesResetStr "brushesReset"
#define kbrushesSaveStr "brushesSave"
#define kbucketToolStr "bucketTool"
#define kbuiltInContourStr "builtInShapeCurve"
#define kbuiltinStr "builtin"
#define kbuiltinProfileStr "builtinProfile"
#define kbuiltinProofStr "builtinProof"
#define kbumpAmplitudeStr "bumpAmplitude"
#define kbumpChannelStr "bumpChannel"
#define kburnInHStr "burnInH"
#define kburnInMStr "burnInM"
#define kburnInSStr "burnInS"
#define kburnInToolStr "burnInTool"
#define kbuttonModeStr "buttonMode"
#define kbyStr "by"
#define kbylineStr "byline"
#define kbylineTitleStr "bylineTitle"
#define kbyteOrderStr "byteOrder"
#define kCIERGBStr "CIERGB"
#define kCMYKSpectrumStr "CMYKSpectrum"
#define kCMYKStr "CMYK"
#define kCMYK64Str "CMYK64"
#define kCMYKColorEnumStr "CMYKColorEnum"
#define kCMYKColorClassStr "CMYKColorClass"
#define kCMYKColorModeStr "CMYKColorMode"
#define kCMYKSetupStr "CMYKSetup"
#define kCMYKSetupEngineStr "CMYKSetupEngine"
#define kcachePrefsStr "cachePrefs"
#define kcalculationTypeStr "calculationType"
#define kcalculationStr "calculation"
#define kcalculationsStr "calculations"
#define kcalibrationBarsStr "calibrationBars"
#define kcanvasSizeStr "canvasSize"
#define kcaptionStr "caption"
#define kcaptionWriterStr "captionWriter"
#define kcascadeStr "cascade"
#define kcategoryStr "category"
#define kcellSizeStr "cellSize"
#define kcenterStr "center"
#define kcenterCropMarksStr "centerCropMarks"
#define kcenteredFrameStr "centeredFrame"
#define kcenterGlowStr "centerGlow"
#define kchalkAreaStr "chalkArea"
#define kchalkCharcoalStr "chalkCharcoal"
#define kchannelStr "channel"
#define kchannelMatrixStr "channelMatrix"
#define kchannelMixerStr "channelMixer"
#define kchannelNameStr "channelName"
#define kchannelOptionsStr "channelOptions"
#define kchannelReferenceStr "channelReference"
#define kchannelRestrictionsStr "channelRestrictions"
#define kchannelsStr "channels"
#define kchannelsInterleavedStr "channelsInterleaved"
#define kchannelsPaletteOptionsStr "channelsPaletteOptions"
#define kcharStr "char"
#define kcharcoalStr "charcoal"
#define kcharcoalAmountStr "charcoalAmount"
#define kcharcoalAreaStr "charcoalArea"
#define kcheckerboardLargeStr "checkerboardLarge"
#define kcheckerboardMediumStr "checkerboardMedium"
#define kcheckerboardNoneStr "checkerboardNone"
#define kcheckerboardSizeStr "checkerboardSize"
#define kcheckerboardSmallStr "checkerboardSmall"
#define kchokeMatteStr "chokeMatte"
#define kchromeStr "chrome"
#define kchromeFXClassStr "chromeFXClass"
#define kchromeFXStr "chromeFX"
#define kcityStr "city"
#define kclassStr "class"
#define kclassColorStr "classColor"
#define kclassContour	"classFXShapeCurve"
#define kclassElementStr "classElement"
#define kclassExportStr "classExport"
#define kclassFormatStr "classFormat"
#define kclassHueSatHueSatV2Str "classHueSatHueSatV2"
#define kclassImportStr "classImport"
#define kclassModeStr "classMode"
#define kclassStringFormatStr "classStringFormat"
#define kclassTextExportStr "classTextExport"
#define kclassTextImportStr "classTextImport"
#define kclearEnumStr "clearEnum"
#define kclearEventStr "clearEvent"
#define kclearAmountStr "clearAmount"
#define kclearGuidesStr "clearGuides"
#define kclearSlicesStr "clearSlices"
#define kclearStyleStr "clearStyle"
#define kclipboardStr "clipboard"
#define kclippingInfoStr "clippingInfo"
#define kclippingPathStr "clippingPath"
#define kclippingPathEPSStr "clippingPathEPS"
#define kclippingPathFlatnessStr "clippingPathFlatness"
#define kclippingPathIndexStr "clippingPathIndex"
#define kclippingPathInfoStr "clippingPathInfo"
#define kcloneSourceStr "cloneSource"
#define kcloneStampToolStr "cloneStampTool"
#define kcloseStr "close"
#define kcloseAllStr "closeAll"
#define kclosedSubpathStr "closedSubpath"
#define kcloudsStr "clouds"
#define kcoarseDotsStr "coarseDots"
#define kcolorSettingsStr "colorSettings"
#define kcolorStr "color"
#define kcolorBalanceStr "colorBalance"
#define kcolorBurnStr "colorBurn"
#define kcolorChannelStr "colorChannel"
#define kcolorChannelsStr "colorChannels"
#define kcolorCorrectionStr "colorCorrection"
#define kcolorDodgeStr "colorDodge"
#define kcolorHalftoneStr "colorHalftone"
#define kcolorIndicatesStr "colorIndicates"
#define kcolorOverlayStr "colorOverlay"
#define kcolorManagementStr "colorManagement"
#define kcolorMatchStr "colorMatch"
#define kcolorNoiseStr "colorNoise"
#define kcolorPaletteStr "colorPalette"
#define kcolorPickerPrefsStr "colorPickerPrefs"
#define kcolorPickerPrefsClassStr "colorPickerPrefsClass"
#define kcolorRangeStr "colorRange"
#define kcolorSamplerListStr "colorSamplerList"
#define kcolorSamplerStr "colorSampler"
#define kcolorSamplerToolStr "colorSamplerTool"
#define kcolorSpaceStr "colorSpace"
#define kcolorStopStr "colorStop"
#define kcolorStopTypeStr "colorStopType"
#define kcolorTableStr "colorTable"
#define kcoloredPencilStr "coloredPencil"
#define kcolorimetricStr "colorimetric"
#define kcolorizeStr "colorize"
#define kcolorSettingsStr "colorSettings"
#define kcolorsStr "colors"
#define kcolorsListStr "colorsList"
#define kcolumnWidthStr "columnWidth"
#define kcombineStr "combine"
#define kcommandStr "command"
#define kcommandKeyStr "commandKey"
#define kcompStr "comp"
#define kcompensationStr "compensation"
#define kcomponentStr "component"
#define kcompositeStr "composite"
#define kcompressionStr "compression"
#define kconcavityStr "concavity"
#define kconditionStr "condition"
#define kconstantStr "constant"
#define kconstrainStr "constrain"
#define kconstrainProportionsStr "constrainProportions"
#define kconstructionFOVStr "constructionFOV"
#define kconteCrayonStr "conteCrayon"
#define kcontentLayerStr "contentLayer"
#define kcontentStr "content"
#define kcontiguousStr "contiguous"
#define kcontinueStr "continue"
#define kcontinuityStr "continuity"
#define kcontourEdgeStr "contourEdge"
#define kContourStr "shapingCurve"
#define kContourCustomStr "shapeCurveCustom"
#define kContourDoubleStr "shapeCurveDouble"
#define kContourGaussianStr "shapeCurveGaussian"
#define kContourLinearStr "shapeCurveLinear"
#define kContourSingleStr "shapeCurveSingle"
#define kContourTripleStr "shapeCurveTriple"
#define kContourTypeStr "shapeCurveType"
#define kcontractStr "contract"
#define kcontrastStr "contrast"
#define kconvertStr "convert"
#define kconvertKnotToolStr "convertKnotTool"
#define kconvertModeStr "convertMode"
#define kconvertToCMYKStr "convertToCMYK"
#define kconvertToGrayStr "convertToGray"
#define kconvertToLabStr "convertToLab"
#define kconvertToProfileStr "convertToProfile"
#define kconvertToRGBStr "convertToRGB"
#define kconvertToShapeStr "convertToShape"
#define kcopyAsHTMLStr "copyAsHTML"
#define kcopyEventStr "copyEvent"
#define kcopyStr "copy"
#define kcopyEffectsStr "copyEffects"
#define kcopyMergedStr "copyMerged"
#define kcopyToLayerStr "copyToLayer"
#define kcopyrightStr "copyright"
#define kcopyrightNoticeStr "copyrightNotice"
#define kcornerStr "corner"
#define kcornerCropMarksStr "cornerCropMarks"
#define kcorrectionMethodStr "correctionMethod"
#define kcountStr "count"
#define kcountryNameStr "countryName"
#define kcrackBrightnessStr "crackBrightness"
#define kcrackDepthStr "crackDepth"
#define kcrackSpacingStr "crackSpacing"
#define kcraquelureStr "craquelure"
#define kcreateDropletStr "createDroplet"
#define kcreateDuplicateStr "createDuplicate"
#define kcreateInterpolationStr "createInterpolation"
#define kcreateLayersFromLayerFXStr "createLayersFromLayerFX"
#define kcreateWorkPathStr "createWorkPath"
#define kcreditStr "credit"
#define kcropStr "crop"
#define kcropToolStr "cropTool"
#define kcrossStr "cross"
#define kcrosshatchStr "crosshatch"
#define kcrossoverStr "crossover"
#define kcrystallizeStr "crystallize"
#define kctrlShiftZEnumStr "ctrlShiftZEnum"
#define kctrlZEnumStr "ctrlZEnum"
#define kctrlYEnumStr "ctrlYEnum"
#define kcurrentColorsStr "currentColors"
#define kcurrentStr "current"
#define kcurrentHistoryStateStr "currentHistoryState"
#define kcurrentLayerStr "currentLayer"
#define kcurrentLightStr "currentLight"
#define kcurrentToolOptionsStr "currentToolOptions"
#define kcursorKindStr "cursorKind"
#define kcurveStr "curve"
#define kcurveFileStr "curveFile"
#define kcurvePointStr "curvePoint"
#define kcurvesStr "curves"
#define kcurvesAdjustmentStr "curvesAdjustment"
#define kcustomStr "custom"
#define kcustomEnumStr "customEnum"
#define kcustomForcedStr "customForced"
#define kcustomShapeStr	"customShape"
#define kcustomShapeToolStr "customShapeTool"
#define kcustomMatteStr "customMatte"
#define kcustomPaletteStr "customPalette"
#define kcustomPaletteClassStr "customPaletteClass"
#define kcustomPatternStr "customPattern"
#define kcustomPhosphorsStr "customPhosphors"
#define kcustomStopsStr "customStops"
#define kcustomWhitePointStr "customWhitePoint"
#define kcutStr "cut"
#define kcutToLayerStr "cutToLayer"
#define kcutoutStr "cutout"
#define kcyanStr "cyan"
#define kcyansStr "cyans"
#define kDCSStr "DCS"
#define kdarkStr "dark"
#define kdarkIntensityStr "darkIntensity"
#define kdarkStrokesStr "darkStrokes"
#define kdarkenStr "darken"
#define kdarkenOnlyStr "darkenOnly"
#define kdarknessStr "darkness"
#define kdashedLinesStr "dashedLines"
#define kdateCreatedStr "dateCreated"
#define kdatumStr "datum"
#define kddmmStr "ddmm"
#define kddmmyyStr "ddmmyy"
#define kdeepStr "deep"
#define kdeInterlaceStr "deInterlace"
#define kdecimalStructStr "decimalStruct"
#define kdeepDepthStr "deepDepth"
#define kdefaultFillStr "defaultFill"
#define kdefineBrushStr "defineBrush"
#define kdefinePatternStr "definePattern"
#define kdefineCustomShapeStr "defineCustomShape"
#define kdefinitionStr "definition"
#define kdefringeStr "defringe"
#define kdeleteAllAnnotStr "deleteAllAnnot"
#define kdeleteContainedStr "deleteContained"
#define kdeleteKnotToolStr "deleteKnotTool"
#define kdeleteStr "delete"
#define kdensityStr "density"
#define kdensityUnitStr "densityUnit"
#define kdepthStr "depth"
#define kdesaturateStr "desaturate"
#define kdeselectStr "deselect"
#define kdespeckleStr "despeckle"
#define kdestBlackMaxStr "destBlackMax"
#define kdestBlackMinStr "destBlackMin"
#define kdestWhiteMaxStr "destWhiteMax"
#define kdestWhiteMinStr "destWhiteMin"
#define kdestinationModeStr "destinationMode"
#define kdetailStr "detail"
#define kdiameterStr "diameter"
#define kdiamondStr "diamond"
#define kdifferenceStr "difference"
#define kdifferenceCloudsStr "differenceClouds"
#define kdiffuseStr "diffuse"
#define kdiffuseGlowStr "diffuseGlow"
#define kdiffuseModeStr "diffuseMode"
#define kdiffusionStr "diffusion"
#define kdiffusionDitherStr "diffusionDither"
#define kdiffusionDitherEnumStr "diffusionDitherEnum"
#define kdirectionStr "direction"
#define kdirectionBalanceStr "directionBalance"
#define kdirectSelectToolStr "directSelectTool"
#define kdisableLayerFXStr "disableLayerFX"
#define kdisableLayerStyleStr "disableLayerStyle"
#define kdiscardVectorMaskStr "discardVectorMask"
#define kdisableSingleFXEventStr "disableSingleFX"
#define kdispatcherIDStr "dispatcherID"
#define kdisplaceStr "displace"
#define kdisplaceFileStr "displaceFile"
#define kdisplacementMapStr "displacementMap"
#define kdisplayCursorsPreferencesStr "displayCursorsPreferences"
#define kdisplayPrefsStr "displayPrefs"
#define kdissolveStr "dissolve"
#define kdistanceStr "distance"
#define kdistanceUnitStr "distanceUnit"
#define kdistortStr "distort"
#define kdistortionStr "distortion"
#define kdistributeStr "distribute"
#define kdistributionStr "distribution"
#define kditherStr "dither"
#define kditherAmountStr "ditherAmount"
#define kditherPreserveStr "ditherPreserve"
#define kditherQualityStr "ditherQuality"
#define kdocumentModeStr "documentMode"
#define kdocumentStr "document"
#define kdocumentReferenceStr "documentReference"
#define kdocumentIDStr "documentID"
#define kdodgeHStr "dodgeH"
#define kdodgeMStr "dodgeM"
#define kdodgeSStr "dodgeS"
#define kdodgeToolStr "dodgeTool"
#define kdontRecordStr "dontRecord"
#define kdotGainStr "dotGain"
#define kdotGainCurvesStr "dotGainCurves"
#define kdotsStr "dots"
#define kdraftStr "draft"
#define kdrawStr "draw"
#define kdropShadowStr "dropShadow"
#define kdryBrushStr "dryBrush"
#define kduotoneStr "duotone"
#define kduotoneInkStr "duotoneInk"
#define kduotoneModeStr "duotoneMode"
#define kduplicateStr "duplicate"
#define kdustAndScratchesStr "dustAndScratches"
#define kdynamicColorSlidersStr "dynamicColorSliders"
#define keBUITUStr "eBUITU"
#define kEPSGenericFormatStr "EPSGenericFormat"
#define kEPSPICTPreviewStr "EPSPICTPreview"
#define kEPSPreviewStr "EPSPreview"
#define kEPSTIFFPreviewStr "EPSTIFFPreview"
#define kedgeStr "edge"
#define kedgeBrightnessStr "edgeBrightness"
#define kedgeFidelityStr "edgeFidelity"
#define kedgeGlowStr "edgeGlow"
#define kedgeIntensityStr "edgeIntensity"
#define kedgeSimplicityStr "edgeSimplicity"
#define kedgeThicknessStr "edgeThickness"
#define kedgeWidthStr "edgeWidth"
#define keffectStr "effect"

#define keffectBevelStr "effectBevel"
#define keffectDropShadowStr "effectDropShadow"
#define keffectInnerGlowStr "effectInnerGlow"
#define keffectInnerShadowStr "effectInnerShadow"
#define keffectNoneStr "effectNone"
#define keffectOuterGlowStr "effectOuterGlow"
#define keffectOverlayStr "effectOverlay"
#define keffectColorOverlayStr "effectColorOverlay"
#define keffectGradientOverlayStr "effectGradientOverlay"
#define keffectPatternOverlayStr "effectPatternOverlay"
#define keffectSatinStr "effectSatin"
#define keffectStrokeStr "effectStroke"

#define kelementStr "element"
#define kelementReferenceStr "elementReference"
#define keliminateEvenFieldsStr "eliminateEvenFields"
#define keliminateOddFieldsStr "eliminateOddFields"
#define kellipseStr "ellipse"
#define kellipseToolStr "ellipseTool"
#define kembedCMYKStr "embedCMYK"
#define kembedFontsStr "embedFonts"
#define kembedGrayStr "embedGray"
#define kembedLabStr "embedLab"
#define kembedProfilesStr "embedProfiles"
#define kembedRGBStr "embedRGB"
#define kembossStr "emboss"
#define kemulsionDownStr "emulsionDown"
#define kenabledStr "enabled"
#define kencodingStr "encoding"
#define kendStr "end"
#define kendArrowheadStr "endArrowhead"
#define kendRampStr "endRamp"
#define kendSustainStr "endSustain"
#define kengineStr "engine"
#define kenumeratedStr "enumerated"
// DON'T NAME THINGS "enumSomething"; just name them "something"
#define kequalizeStr "equalize"
#define keraseToHistoryStr "eraseToHistory"
#define keraserKindStr "eraserKind"
#define keraserToolStr "eraserTool"
#define keventClassAttrStr "eventClassAttr"
#define keventIDAttrStr "eventIDAttr"
#define keventRecordStr "eventRecord"
#define keventSourceAttrStr "eventSourceAttr"
#define kexactStr "exact"
#define kexactPointsStr "exactPoints"
#define kexchangeStr "exchange"
#define kexcludeIntersectionStr "excludeIntersection"
#define kexclusionStr "exclusion"
#define kexpandStr "expand"
#define kexportStr "export"
#define kexportClipboardStr "exportClipboard"
#define kexposureStr "exposure"
#define kextendStr "extend"
#define kextendedStr "extended"
#define kextendedQualityStr "extendedQuality"
#define kextensionStr "extension"
#define kextensionsQueryStr "extensionsQuery"
#define kextrudeStr "extrude"
#define kextrudeDepthStr "extrudeDepth"
#define kextrudeMaskIncompleteStr "extrudeMaskIncomplete"
#define kextrudeRandomStr "extrudeRandom"
#define kextrudeSizeStr "extrudeSize"
#define kextrudeSolidFaceStr "extrudeSolidFace"
#define kextrudeTypeStr "extrudeType"
#define keyeDropperSampleTypeStr "eyeDropperSampleType"
#define keyeDropperSampleStr "eyeDropperSample"
#define keyedropperToolStr "eyedropperTool"
#define kfalloffStr "falloff"
#define kFPXCompressStr "FPXCompress"
#define kFPXCompressLossyJPEGStr "FPXCompressLossyJPEG"
#define kFPXCompressNoneStr "FPXCompressNone"
#define kFPXQualityStr "FPXQuality"
#define kFPXSizeStr "FPXSize"
#define kFPXViewStr "FPXView"
#define kFSSStr "FSS"
#define kfacetStr "facet"
#define kfadeStr "fade"
#define kfadeToStr "fadeTo"
#define kfadeoutStepsStr "fadeoutSteps"
#define kfalseStr "false"
#define kfasterStr "faster"
#define kfeatherStr "feather"
#define kfiberLengthStr "fiberLength"
#define kfileNamingComponentStr "fileNamingComponent"
#define kfileNamingComponentsStr "fileNamingComponents"
#define kfileNamingRulesStr "fileNamingRules"
#define kfileEnumStr "fileEnum"
#define kfileStr "file"
#define kfileCreatorStr "fileCreator"
#define kfileInfoStr "fileInfo"
#define kfileReferenceStr "fileReference"
#define kfileSavePrefsStr "fileSavePrefs"
#define kfileSavePrefsClassStr "fileSavePrefsClass"
#define kfileTypeStr "fileType"
#define kfillFirstStr "fillFirst"
#define kfillOpacityStr "fillOpacity"
#define kfillStr "fill"
#define kfillBackStr "fillBack"
#define kfillColorStr "fillColor"
#define kfillContentsStr "fillContents"
#define kfillForeStr "fillFore"
#define kfillInverseStr "fillInverse"
#define kfillModeStr "fillMode"
#define kfillNeutralStr "fillNeutral"
#define kfillSameStr "fillSame"
#define kfilmGrainStr "filmGrain"
#define kfilterStr "filter"
#define kfindEdgesStr "findEdges"
#define kfineDotsStr "fineDots"
#define kfingerpaintingStr "fingerpainting"
#define kfirstStr "first"
#define kfirstIdleStr "firstIdle"
#define kfitOnScreenStr "fitOnScreen"
#define kfixedStr "fixed"
#define kflareCenterStr "flareCenter"
#define kflashPixFormatStr "flashPixFormat"
#define kflatnessStr "flatness"
#define kflattenStr "flatten"
#define kflattenImageStr "flattenImage"
#define kflipStr "flip"
#define kfloatTypeStr "floatType"
#define kfloatUnitStr "floatUnit"
#define kfocusStr "focus"
#define kfoldersStr "folders"
#define kfontDesignAxesStr "fontDesignAxes"
#define kfontDesignAxesVectorsStr "fontDesignAxesVectors"
#define kfontNameStr "fontName"
#define kfontScriptStr "fontScript"
#define kfontSizeStr "fontSize"
#define kfontStyleNameStr "fontStyleName"
#define kfontTechnologyStr "fontTechnology"
#define kforcedColorsStr "forcedColors"
#define kforegroundColorStr "foregroundColor"
#define kforegroundLevelStr "foregroundLevel"
#define kformatStr "format"
#define kforwardStr "forward"
#define kforwardEnumStr "forwardEnum"
#define kfragmentStr "fragment"
#define kframeFillStr "frameFill"
#define kframeStyleStr "frameStyle"
#define kframeFXStr "frameFX"
#define kframeFXClassStr "frameFXClass"
#define kframeWidthStr "frameWidth"
#define kfreeformPenToolStr "freeformPenTool"
#define kfreeTransformStr "freeTransform"
#define kfreeTransformCenterStateStr "freeTransformCenterState"
#define kfrequencyStr "frequency"
#define kfrescoStr "fresco"
#define kfromStr "from"
#define kfromBuiltinStr "fromBuiltin"
#define kfromModeStr "fromMode"
#define kfrontStr "front"
#define kfullDocumentStr "fullDocument"
#define kfullSizeStr "fullSize"
#define kfunctionKeyStr "functionKey"
#define kfuzzinessStr "fuzziness"
#define kGCRStr "GCR"
#define kGIF89aExportStr "GIF89aExport"
#define kGIFColorFileColorTableStr "GIFColorFileColorTable"
#define kGIFColorFileColorsStr "GIFColorFileColors"
#define kGIFColorFileMicrosoftPaletteStr "GIFColorFileMicrosoftPalette"
#define kGIFColorFileTypeStr "GIFColorFileType"
#define kGIFColorLimitStr "GIFColorLimit"
#define kGIFExportCaptionStr "GIFExportCaption"
#define kGIFFormatStr "GIFFormat"
#define kGIFMaskChannelIndexStr "GIFMaskChannelIndex"
#define kGIFMaskChannelInvertedStr "GIFMaskChannelInverted"
#define kGIFPaletteAdaptiveStr "GIFPaletteAdaptive"
#define kGIFPaletteExactStr "GIFPaletteExact"
#define kGIFPaletteFileStr "GIFPaletteFile"
#define kGIFPaletteOtherStr "GIFPaletteOther"
#define kGIFPaletteSystemStr "GIFPaletteSystem"
#define kGIFPaletteTypeStr "GIFPaletteType"
#define kGIFRequiredColorSpaceIndexedStr "GIFRequiredColorSpaceIndexed"
#define kGIFRequiredColorSpaceRGBStr "GIFRequiredColorSpaceRGB"
#define kGIFRequiredColorSpaceTypeStr "GIFRequiredColorSpaceType"
#define kGIFRowOrderInterlacedStr "GIFRowOrderInterlaced"
#define kGIFRowOrderNormalStr "GIFRowOrderNormal"
#define kGIFRowOrderTypeStr "GIFRowOrderType"
#define kGIFTransparentColorStr "GIFTransparentColor"
#define kGIFTransparentIndexBlueStr "GIFTransparentIndexBlue"
#define kGIFTransparentIndexGreenStr "GIFTransparentIndexGreen"
#define kGIFTransparentIndexRedStr "GIFTransparentIndexRed"
#define kGIFUseBestMatchStr "GIFUseBestMatch"
#define kgammaStr "gamma"
#define kgamutWarningStr "gamutWarning"
#define kgaussianBlurStr "gaussianBlur"
#define kgaussianDistributionStr "gaussianDistribution"
#define kgeneralPreferencesStr "generalPreferences"
#define kgeneralPrefsStr "generalPrefs"
#define kgetStr "get"
#define kglassStr "glass"
#define kglobalAltitudeStr "globalAltitude"
#define kglobalAngleStr "globalAngle"
#define kglobalClassStr "globalClass"
#define kglobalLightingAltitudeStr "globalAltitude"
#define kglobalLightingAngleStr "globalLightingAngle"
#define kglobalObjectStr "globalObject"
#define kglossStr "gloss"
#define kglowAmountStr "glowAmount"
#define kglowTechniqueStr "glowTechnique"
#define kglowingEdgesStr "glowingEdges"
#define kgoodStr "good"
#define kgradientClassEventStr "gradientClassEvent"
#define kgradientLayerStr "gradientLayer"
#define kgradientStr "gradient"
#define kgradientFillStr "gradientFill"
#define kgradientFormStr "gradientForm"
#define kgradientMapClassStr "gradientMapClass"
#define kgradientMapEventStr "gradientMapEvent"
#define kgradientOverlayStr "gradientOverlay"
#define kgradientToolStr "gradientTool"
#define kgradientTypeStr "gradientType"
#define kgrainStr "grain"
#define kgrainClumpedStr "grainClumped"
#define kgrainContrastyStr "grainContrasty"
#define kgrainEnlargedStr "grainEnlarged"
#define kgrainHorizontalStr "grainHorizontal"
#define kgrainRegularStr "grainRegular"
#define kgrainSoftStr "grainSoft"
#define kgrainSpeckleStr "grainSpeckle"
#define kgrainSprinklesStr "grainSprinkles"
#define kgrainStippledStr "grainStippled"
#define kgrainTypeStr "grainType"
#define kgrainVerticalStr "grainVertical"
#define kgraininessStr "graininess"
#define kgrainyDotsStr "grainyDots"
#define kgraphicPenStr "graphicPen"
#define kgraphicsStr "graphics"
#define kgrayStr "gray"
#define kgray16Str "gray16"
#define kgray18Str "gray18"
#define kgray22Str "gray22"
#define kgray50Str "gray50"
#define kgrayBehaviorStr "grayBehavior"
#define kgrayScaleRampStr "grayScaleRamp"
#define kgrayScaleStr "grayScale"
#define kgraySetupStr "graySetup"
#define kgrayscaleStr "grayscale"
#define kgrayscaleModeStr "grayscaleMode"
#define kgreenStr "green"
#define kgreenBlackPointStr "greenBlackPoint"
#define kgreenGammaStr "greenGamma"
#define kgreenWhitePointStr "greenWhitePoint"
#define kgreenXStr "greenX"
#define kgreenYStr "greenY"
#define kgreensStr "greens"
#define kgridColorStr "gridColor"
#define kgridCustomColorStr "gridCustomColor"
#define kgridMajorStr "gridMajor"
#define kgridMinorStr "gridMinor"
#define kgridStyleStr "gridStyle"
#define kgridUnitsStr "gridUnits"
#define kgroupStr "group"
#define kgroupEventStr "groupEvent"
#define kgroutWidthStr "groutWidth"
#define kgrowStr "grow"
#define kguideStr "guide"
#define kguideGridColorStr "guideGridColor"
#define kguideGridStyleStr "guideGridStyle"
#define kguidesStr "guides"
#define kguidesColorStr "guidesColor"
#define kguidesCustomColorStr "guidesCustomColor"
#define kguidesGridPreferencesStr "guidesGridPreferences"
#define kguidesPrefsStr "guidesPrefs"
#define kguidesStyleStr "guidesStyle"
#define kgutterWidthStr "gutterWidth"
#define kHDTVStr "HDTV"
#define kHSBColorEnumStr "HSBColorEnum"
#define kHSBColorClassStr "HSBColorClass"
#define kHSBColorModeStr "HSBColorMode"
#define kHSLColorStr "HSLColor"
#define khalftoneFileStr "halftoneFile"
#define khalftoneScreenStr "halftoneScreen"
#define khalftoneSizeStr "halftoneSize"
#define khalftoneSpecStr "halftoneSpec"
#define khandToolStr "handTool"
#define khardLightStr "hardLight"
#define khardnessStr "hardness"
#define khardProofStr "hardProof"
#define kheaderStr "header"
#define kheadlineStr "headline"
#define kheavyStr "heavy"
#define kheightStr "height"
#define khideStr "hide"
#define khideAllStr "hideAll"
#define khideSelectionStr "hideSelection"
#define khighStr "high"
#define khighPassStr "highPass"
#define khighQualityStr "highQuality"
#define khighlightAreaStr "highlightArea"
#define khighlightColorStr "highlightColor"
#define khighlightLevelsStr "highlightLevels"
#define khighlightModeStr "highlightMode"
#define khighlightOpacityStr "highlightOpacity"
#define khighlightStrengthStr "highlightStrength"
#define khighlightsStr "highlights"
#define khistogramStr "histogram"
#define khistoryStr "history"
#define khistoryBrushSourceStr "historyBrushSource"
#define khistoryBrushToolStr "historyBrushTool"
#define khistoryPaletteOptionsStr "historyPaletteOptions"
#define khistoryPreferencesStr "historyPreferences"
#define khistoryPrefsClassStr "historyPrefsClass"
#define khistoryPrefsStr "historyPrefs"
#define khistoryStateStr "historyState"
#define khistoryStateSourceTypeStr "historyStateSourceType"
#define khistoryStateSourceStr "historyStateSource"
#define khistoryStatesStr "historyStates"
#define khorizontalStr "horizontal"
#define khorizontalLocationStr "horizontalLocation"
#define khorizontalOnlyStr "horizontalOnly"
#define khorizontalScaleStr "horizontalScale"
#define khostNameStr "hostName"
#define khostVersionStr "hostVersion"
#define khtmlTextStr "htmlText"
#define khueStr "hue"
#define khueSatAdjustmentStr "hueSatAdjustment"
#define khueSatAdjustmentV2Str "hueSatAdjustmentV2"
#define khueSaturationStr "hueSaturation"
#define kIBMPCStr "IBMPC"
#define kICCStr "ICC"
#define kICCEngineStr "ICCEngine"
#define kICCSetupNameStr "ICCSetupName"
#define kIDStr "ID"
#define kIEEE32BitFloatingPointStr "IEEE32BitFloatingPoint"
#define kIEEE64BitFloatingPointStr "IEEE64BitFloatingPoint"
#define kiconStr "icon"
#define kidleStr "idle"
#define kidleVMStr "idleVM"
#define kignoreStr "ignore"
#define killustratorPathsExportStr "illustratorPathsExport"
#define kimageStr "image"
#define kimageBalanceStr "imageBalance"
#define kimageCachePreferencesStr "imageCachePreferences"
#define kimageInterpolationStr "imageInterpolation"
#define kimagePointStr "imagePoint"
#define kimageReferenceStr "imageReference"
#define kimageSizeStr "imageSize"
#define kimageTypeStr "imageType"
#define kimportAnnotsStr "importAnnots"
#define kimportStr "import"
#define kimpressionistStr "impressionist"
#define kincludeVectorDataStr "includeVectorData"
#define kinStr "in"
#define kindentStr "indent"
#define kindexedColorStr "indexedColor"
#define kindexedColorModeStr "indexedColorMode"
#define kinfoPaletteOptionsStr "infoPaletteOptions"
#define kinfoPaletteToggleSamplersStr "infoPaletteToggleSamplers"
#define kinheritsStr "inherits"
#define kinkBlackStr "inkBlack"
#define kinkColorsStr "inkColors"
#define kinkOutlinesStr "inkOutlines"
#define kinkTransferStr "inkTransfer"
#define kinksStr "inks"
#define kinnerBevelStr "innerBevel"
#define kinnerGlowStr "innerGlow"
#define kinnerGlowSourceStr "innerGlowSource"
#define kinnerGlowSourceTypeStr "innerGlowSourceType"
#define kinnerShadowStr "innerShadow"
#define kinputStr "input"
#define kinputMapRangeStr "inputMapRange"
#define kinputRangeStr "inputRange"
#define kinsetFrameStr "insetFrame"
#define kinsideStr "inside"
#define kintegerStr "integer"
#define kintegerChannelStr "integerChannel"
#define kintensityStr "intensity"
#define kintentStr "intent"
#define kinteractLevelAttrStr "interactLevelAttr"
#define kinterfaceBevelHighlightStr "interfaceBevelHighlight"
#define kinterfaceBevelShadowStr "interfaceBevelShadow"
#define kinterfaceBlackStr "interfaceBlack"
#define kinterfaceBorderStr "interfaceBorder"
#define kinterfaceButtonDarkShadowStr "interfaceButtonDarkShadow"
#define kinterfaceButtonDownFillStr "interfaceButtonDownFill"
#define kinterfaceButtonUpFillStr "interfaceButtonUpFill"
#define kinterfaceColorStr "interfaceColor"
#define kinterfaceColorBlue2Str "interfaceColorBlue2"
#define kinterfaceColorBlue32Str "interfaceColorBlue32"
#define kinterfaceColorGreen2Str "interfaceColorGreen2"
#define kinterfaceColorGreen32Str "interfaceColorGreen32"
#define kinterfaceColorRed2Str "interfaceColorRed2"
#define kinterfaceColorRed32Str "interfaceColorRed32"
#define kinterfaceIconFillActiveStr "interfaceIconFillActive"
#define kinterfaceIconFillDimmedStr "interfaceIconFillDimmed"
#define kinterfaceIconFillSelectedStr "interfaceIconFillSelected"
#define kinterfaceIconFrameActiveStr "interfaceIconFrameActive"
#define kinterfaceIconFrameDimmedStr "interfaceIconFrameDimmed"
#define kinterfaceIconFrameSelectedStr "interfaceIconFrameSelected"
#define kinterfacePaletteFillStr "interfacePaletteFill"
#define kinterfaceRedStr "interfaceRed"
#define kinterfaceToolTipBackgroundStr "interfaceToolTipBackground"
#define kinterfaceToolTipTextStr "interfaceToolTipText"
#define kinterfaceTransparencyBackgroundStr "interfaceTransparencyBackground"
#define kinterfaceTransparencyForegroundStr "interfaceTransparencyForeground"
#define kinterfaceWhiteStr "interfaceWhite"
#define kinterlaceStr "interlace"
#define kinterlaceCreateTypeStr "interlaceCreateType"
#define kinterlaceEliminateTypeStr "interlaceEliminateType"
#define kinterpolationStr "interpolation"
#define kinterpolationTypeStr "interpolationType"
#define kinterpolationMethodStr "interpolationMethod"
#define kintersectStr "intersect"
#define kintersectWithStr "intersectWith"
#define kinverseStr "inverse"
#define kinvertStr "invert"
#define kinvertMaskStr "invertMask"
#define kinvertSource2Str "invertSource2"
#define kinvertTextureStr "invertTexture"
#define kisDirtyStr "isDirty"
#define kitemIndexStr "itemIndex"
#define kJPEGStr "JPEG"
#define kJPEGFormatStr "JPEGFormat"
#define kJPEGQualityStr "JPEGQuality"
#define kjumptoStr "jumpto"
#define kjustifyAllStr "justifyAll"
#define kjustifyFullStr "justifyFull"
#define kkeepProfileStr "keepProfile"
#define kkelvinStr "kelvin"
#define kkelvinCustomWhitePointStr "kelvinCustomWhitePoint"
#define kkernelProcessIDStr "kernelProcessID"
#define kkerningStr "kerning"
#define kkeyboardPreferencesStr "keyboardPreferences"
#define kkeywordStr "keyword"
#define kkeywordsStr "keywords"
#define kkindStr "kind"
#define kknockoutStr "knockout"
#define kLUTAnimationStr "LUTAnimation"
#define kLZWCompressionStr "LZWCompression"
#define klabStr "lab"
#define klab48Str "lab48"
#define klabColorStr "labColor"
#define klabColorModeStr "labColorMode"
#define klabelsStr "labels"
#define klandscapeStr "landscape"
#define klargeStr "large"
#define klassoToolStr "lassoTool"
#define klastStr "last"
#define klastFilterStr "lastFilter"
#define klastTransformStr "lastTransform"
#define klayerStr "layer"
#define klayerConcealsStr "layerConceals"
#define klayerEffectsStr "layerEffects"
#define klayerFXVisibleStr "layerFXVisible"
#define klayerIDStr "layerID"
#define klayerLockingStr "layerLocking"
#define klayerNameStr "layerName"
#define klayerOptionsStr "layerOptions"
#define klayerSectionStr "layerSection"
#define klayerSetFromLinkedEventStr "layerSetFromLinkedEvent"
#define klayersStr "layers"
#define klayersPaletteOptionsStr "layersPaletteOptions"
#define kleadingStr "leading"
#define kleftStr "left"
#define kleftPluginStr "leftPlugin"
#define klengthStr "length"
#define klensStr "lens"
#define klensFlareStr "lensFlare"
#define klevelStr "level"
#define klevelBasedStr "levelBased"
#define klevelsStr "levels"
#define klevelsAdjustmentStr "levelsAdjustment"
#define klightStr "light"
#define klightBlueStr "lightBlue"
#define klightDarkStr "lightDark"
#define klightDirBottomStr "lightDirBottom"
#define klightDirBottomLeftStr "lightDirBottomLeft"
#define klightDirBottomRightStr "lightDirBottomRight"
#define klightDirLeftStr "lightDirLeft"
#define klightDirRightStr "lightDirRight"
#define klightDirTopStr "lightDirTop"
#define klightDirTopLeftStr "lightDirTopLeft"
#define klightDirTopRightStr "lightDirTopRight"
#define klightDirectionStr "lightDirection"
#define klightDirectionalStr "lightDirectional"
#define klightGrayStr "lightGray"
#define klightIntensityStr "lightIntensity"
#define klightOmniStr "lightOmni"
#define klightPosBottomStr "lightPosBottom"
#define klightPosBottomLeftStr "lightPosBottomLeft"
#define klightPosBottomRightStr "lightPosBottomRight"
#define klightPosLeftStr "lightPosLeft"
#define klightPosRightStr "lightPosRight"
#define klightPosTopStr "lightPosTop"
#define klightPosTopLeftStr "lightPosTopLeft"
#define klightPosTopRightStr "lightPosTopRight"
#define klightPositionStr "lightPosition"
#define klightRedStr "lightRed"
#define klightSourceStr "lightSource"
#define klightSpotStr "lightSpot"
#define klightTypeStr "lightType"
#define klightenStr "lighten"
#define klightenGroutStr "lightenGrout"
#define klightenOnlyStr "lightenOnly"
#define klightingEffectsStr "lightingEffects"
#define klightnessStr "lightness"
#define klineStr "line"
#define klineClassStr "lineClass"
#define klineToolStr "lineTool"
#define klinearStr "linear"
#define klinesStr "lines"
#define klinkStr "link"
#define klinkToOtherEffectsStr "linkToOtherEffects"
#define klinkedStr "linked"
#define klinkedLayerIDsStr "linkedLayerIDs"
#define klocalLightingAltitudeStr "localLightingAltitude"
#define klocalLightingAngleStr "localLightingAngle"
#define klocalRangeStr "localRange"
#define klocationStr "location"
#define klocationReferenceStr "locationReference"
#define klogStr "log"
#define klongFloatStr "longFloat"
#define klongIntegerStr "longInteger"
#define klongLinesStr "longLines"
#define klongStrokesStr "longStrokes"
#define klowStr "low"
#define klowQualityStr "lowQuality"
#define klowerStr "lower"
#define klowerCaseSerialStr "lowerCaseSerial"
#define klowerCaseStr "lowerCase"
#define klowerCaseExtensionStr "lowerCaseExtension"
#define kluminanceStr "luminance"
#define kluminosityStr "luminosity"
#define kmacPaintFormatStr "macPaintFormat"
#define kmacThumbnailStr "macThumbnail"
#define kmacintoshStr "macintosh"
#define kmacintoshSystemStr "macintoshSystem"
#define kmagentaStr "magenta"
#define kmagentasStr "magentas"
#define kmagicEraserToolStr "magicEraserTool"
#define kmagicPointStr "magicPoint"
#define kmagicWandToolStr "magicWandTool"
#define kmagneticLassoToolStr "magneticLassoTool"
#define kmagnitudeStr "magnitude"
#define kmakeStr "make"
#define kmakeVisibleStr "makeVisible"
#define kmarqueeEllipToolStr "marqueeEllipTool"
#define kmarqueeRectToolStr "marqueeRectTool"
#define kmanageStr "manage"
#define kmanipulationFOVStr "manipulationFOV"
#define kmapBlackStr "mapBlack"
#define kmappingStr "mapping"
#define kmappingShapeStr "mappingShape"
//#define kmasksOnlyStr "masksOnly"
#define kmaskStr "mask"
#define kmaskIndicatorStr "maskIndicator"
#define kmaskedAreasStr "maskedAreas"
#define kmasterAdaptiveStr "masterAdaptive"
#define kmasterFXSwitchStr "masterFXSwitch"
#define kmasterPerceptualStr "masterPerceptual"
#define kmasterSelectiveStr "masterSelective"
#define kmaterialStr "material"
#define kmatrixStr "matrix"
#define kmatteColorStr "matteColor"
#define kmatteTechniqueStr "matteTechnique"
#define kmaximumEnumStr "maximumEnum"
#define kmaximumStr "maximum"
#define kmaximumQualityStr "maximumQuality"
#define kmaximumStatesStr "maximumStates"
#define kmeasureToolStr "measureTool"
#define kmedianStr "median"
#define kmediumStr "medium"
#define kmediumBlueStr "mediumBlue"
#define kmediumDotsStr "mediumDots"
#define kmediumLinesStr "mediumLines"
#define kmediumQualityStr "mediumQuality"
#define kmediumStrokesStr "mediumStrokes"
#define kmemoryPreferencesStr "memoryPreferences"
#define kmemoryUsagePercentStr "memoryUsagePercent"
#define kmenuItemClassStr "menuItemClass"
#define kmenuItemTypeStr "menuItemType"
#define kmergeStr "merge"
#define kmergeChannelsStr "mergeChannels"
#define kmergeLayersStr "mergeLayers"
#define kmergeSpotChannelStr "mergeSpotChannel"
#define kmergeVisibleStr "mergeVisible"
#define kmergedStr "merged"
#define kmergedLayersStr "mergedLayers"
#define kmessageStr "message"
#define kmethodStr "method"
#define kmezzotintStr "mezzotint"
#define kmezzotintTypeStr "mezzotintType"
#define kmiddleStr "middle"
#define kmidpointStr "midpoint"
#define kmidtoneLevelsStr "midtoneLevels"
#define kmidtonesStr "midtones"
#define kminimumStr "minimum"
#define kmismatchCMYKStr "mismatchCMYK"
#define kmismatchGrayStr "mismatchGray"
#define kmismatchRGBStr "mismatchRGB"
#define kmissedKeywordAttrStr "missedKeywordAttr"
#define kmmddStr "mmdd"
#define kmmddyyStr "mmddyy"
#define kmodeStr "mode"
#define kmodeGrayStr "modeGray"
#define kmodeRGBStr "modeRGB"
#define kmonitorStr "monitor"
#define kmonitorCompressionStr "monitorCompression"
#define kmonitorRGBStr "monitorRGB"
#define kmonitorSetupStr "monitorSetup"
#define kmonochromaticStr "monochromatic"
#define kmonotoneStr "monotone"
#define kmosaicStr "mosaic"
#define kmosaicPluginStr "mosaicPlugin"
#define kmotionBlurStr "motionBlur"
#define kmoveStr "move"
#define kmoveToStr "moveTo"
#define kmoveToolStr "moveTool"
#define kmulti72ColorStr "multi72Color"
#define kmulti72GrayStr "multi72Gray"
#define kmultiNoCompositePSStr "multiNoCompositePS"
#define kmultichannelStr "multichannel"
#define kmultichannelModeStr "multichannelMode"
#define kmultiplyStr "multiply"
#define kNTSCStr "NTSC"
#define kNTSCColorsStr "NTSCColors"
#define knameStr "name"
#define knavigatorPaletteOptionsStr "navigatorPaletteOptions"
#define knearestNeighborStr "nearestNeighbor"
#define knegativeStr "negative"
#define kneonGlowStr "neonGlow"
#define knetscapeGrayStr "netscapeGray"
#define kneutralsStr "neutrals"
#define knewGuideStr "newGuide"
#define knewStr "new"
#define knewViewStr "newView"
#define knextStr "next"
#define knikonStr "nikon"
#define knikon105Str "nikon105"
#define knoImageStr "noImage"
#define knoStr "no"
#define knoCompositePSStr "noCompositePS"
#define knoiseStr "noise"
#define knoneUnitStr "noneUnit"
#define knonImageDataStr "nonImageData"
#define knonLinearStr "nonLinear"
#define knoneStr "none"
#define knormalStr "normal"
#define knormalPathStr "normalPath"
#define knotePaperStr "notePaper"
#define knotifyStr "notify"
#define knullStr "null"
#define knumLightsStr "numLights"
#define knumberStr "number"
#define knumberOfCacheLevelsStr "numberOfCacheLevels"
#define knumberOfChannelsStr "numberOfChannels"
#define knumberOfChildrenStr "numberOfChildren"
#define knumberOfDocumentsStr "numberOfDocuments"
#define knumberOfGeneratorsStr "numberOfGenerators"
#define knumberOfLayersStr "numberOfLayers"
#define knumberOfLevelsStr "numberOfLevels"
#define knumberOfPathsStr "numberOfPaths"
#define knumberOfRipplesStr "numberOfRipples"
#define knumberOfSiblingsStr "numberOfSiblings"
#define kOS2Str "OS2"
#define kobjectStr "object"
#define kobjectNameStr "objectName"
#define kobjectReferenceStr "objectReference"
#define kobsoleteTextLayerStr "obsoleteTextLayer"
#define koceanRippleStr "oceanRipple"
#define koffStr "off"
#define koffsetStr "offset"
#define konStr "on"
#define koneDigitStr "oneDigit"
#define konOffStr "onOff"
#define kopacityClassStr "opacityClass"
#define kopacityStr "opacity"
#define kopenStr "open"
#define kopenAsStr "openAs"
#define koptimizedStr "optimized"
#define koptionalKeywordAttrStr "optionalKeywordAttr"
#define korangeStr "orange"
#define kordinalStr "ordinal"
#define korientationStr "orientation"
#define koriginalAddressAttrStr "originalAddressAttr"
#define koriginalHeaderStr "originalHeader"
#define koriginalTransmissionReferenceStr "originalTransmissionReference"
#define kotherCursorsStr "otherCursors"
#define koutFromCenterStr "outFromCenter"
#define koutOfGamutStr "outOfGamut"
#define kouterBevelStr "outerBevel"
#define kouterGlowStr "outerGlow"
#define koutputStr "output"
#define koutsetFrameStr "outsetFrame"
#define koutsideStr "outside"
#define koverlayStr "overlay"
#define koverprintColorsStr "overprintColors"
#define koverrideOpenStr "overrideOpen"
#define koverridePrinterStr "overridePrinter"
#define koverrideSaveStr "overrideSave"
#define kpaintTypeStr "paintType"
#define kpassThroughStr	"passThrough"
#define kP22EBUStr "P22EBU"
#define kpercentUnitStr "percentUnit"
#define kPDFGenericFormatStr "PDFGenericFormat"
#define kPICTFileFormatStr "PICTFileFormat"
#define kPICTResourceFormatStr "PICTResourceFormat"
#define kpInheritsStr "pInherits"
#define kPNGFilterStr "PNGFilter"
#define kPNGFilterAdaptiveStr "PNGFilterAdaptive"
#define kPNGFilterAverageStr "PNGFilterAverage"
#define kPNGFilterNoneStr "PNGFilterNone"
#define kPNGFilterPaethStr "PNGFilterPaeth"
#define kPNGFilterSubStr "PNGFilterSub"
#define kPNGFilterUpStr "PNGFilterUp"
#define kPNGFormatStr "PNGFormat"
#define kPNGInterlaceAdam7Str "PNGInterlaceAdam7"
#define kPNGInterlaceNoneStr "PNGInterlaceNone"
#define kPNGInterlaceTypeStr "PNGInterlaceType"
#define kpageFormatStr "pageFormat"
#define kpageNumberStr "pageNumber"
#define kpagePosCenteredStr "pagePosCentered"
#define kpagePosTopLeftStr "pagePosTopLeft"
#define kpagePositionStr "pagePosition"
#define kpageSetupStr "pageSetup"
#define kpaintStr "paint"
#define kpaintDaubsStr "paintDaubs"
#define kpaintStrokeStr "paintStroke"
#define kpaintbrushEraserStr "paintbrushEraser"
#define kpaintbrushToolStr "paintbrushTool"
#define kpaintingCursorsStr "paintingCursors"
#define kpalSecamStr "palSecam"
#define kpaletteStr "palette"
#define kpaletteFileStr "paletteFile"
#define kpaletteKnifeStr "paletteKnife"
#define kpanaVisionStr "panaVision"
#define kpaperBrightnessStr "paperBrightness"
#define kpaperWhiteStr "paperWhite"
#define kparentIndexStr "parentIndex"
#define kparentNameStr "parentName"
#define kpasteStr "paste"
#define kpasteEffectsStr "pasteEffects"
#define kpasteIntoStr "pasteInto"
#define kpasteOutsideStr "pasteOutside"
#define kpatchworkStr "patchwork"
#define kpathStr "path"
#define kpathClassStr "pathClass"
#define kpathComponentStr "pathComponent"
#define kpathComponentsStr "pathComponents"
#define kpathComponentSelectToolStr "pathComponentSelectTool"
#define kpathContentsStr "pathContents"
#define kpathKindStr "pathKind"
#define kpathNameStr "pathName"
#define kpathPointStr "pathPoint"
#define kpathReferenceStr "pathReference"
#define kpathsPaletteOptionsStr "pathsPaletteOptions"
#define kpatternDitherStr "patternDither"
#define kpatternFillStr	"patternFill"
#define kpatternFillClassStr "patternFillClass"
#define kpatternKeyStr "patternKey"
#define kpatternLayerStr "patternLayer"
#define kpatternOverlayStr "patternOverlay"
#define kpatternStampToolStr "patternStampTool"
#define kpatternStr "pattern"
#define kpauseForAudioStr "pauseForAudio"
#define kpauseStr "pause"
#define kpenToolStr "penTool"
#define kpencilEraserStr "pencilEraser"
#define kpencilToolStr "pencilTool"
#define kpencilWidthStr "pencilWidth"
#define kperceptualStr "perceptual"
#define kperformanceStr "performance"
#define kperspectiveStr "perspective"
#define kperspectiveIndexStr "perspectiveIndex"
#define kphaseStr "phase"
#define kphosphorsStr "phosphors"
#define kphosphorsCustomPhosphorsStr "phosphorsCustomPhosphors"
#define kphotocopyStr "photocopy"
#define kphotoshop20FormatStr "photoshop20Format"
#define kphotoshop35FormatStr "photoshop35Format"
#define kphotoshopDCS2FormatStr "photoshopDCS2Format"
#define kphotoshopDCSFormatStr "photoshopDCSFormat"
#define kphotoshopEPSFormatStr "photoshopEPSFormat"
#define kphotoshopPDFFormatStr "photoshopPDFFormat"
#define kphotoshopPickerStr "photoshopPicker"
#define kpickCMYKStr "pickCMYK"
#define kpickGrayStr "pickGray"
#define kpickHSBStr "pickHSB"
#define kpickLabStr "pickLab"
#define kpickOptionsStr "pickOptions"
#define kpickRGBStr "pickRGB"
#define kpickWebStr "pickWeb"
#define kpickerIDStr "pickerID"
#define kpickerKindTypeStr "pickerKindType"
#define kpickerKindStr "pickerKind"
#define kpillowEmbossStr "pillowEmboss"
#define kpinchStr "pinch"
#define kpixelStr "pixel"
#define kpixelDoublingStr "pixelDoubling"
#define kpixelPaintFormatStr "pixelPaintFormat"
#define kpixelPaintSizeStr "pixelPaintSize"
#define kpixelPaintSize1Str "pixelPaintSize1"
#define kpixelPaintSize2Str "pixelPaintSize2"
#define kpixelPaintSize3Str "pixelPaintSize3"
#define kpixelPaintSize4Str "pixelPaintSize4"
#define kpixelsUnitStr "pixelsUnit"
#define kplaceEventStr "placeEvent"
#define kplaceEnumStr "placeEnum"
#define kplasterStr "plaster"
#define kplasticWrapStr "plasticWrap"
#define kplatformStr "platform"
#define kplayStr "play"
#define kplaybackOptionsStr "playbackOptions"
#define kpluginFolderStr "pluginFolder"
#define kpluginPickerStr "pluginPicker"
#define kpluginPrefsStr "pluginPrefs"
#define kpluginsScratchDiskPreferencesStr "pluginsScratchDiskPreferences"
#define kpointStr "point"
#define kpoint16Str "point16"
#define kpointillizeStr "pointillize"
#define kpointsStr "points"
#define kpolarStr "polar"
#define kpolarToRectStr "polarToRect"
#define kpolicyStr "policy"
#define kpolicyCMYKStr "policyCMYK"
#define kpolicyGrayStr "policyGray"
#define kpolicyRGBStr "policyRGB"
#define kpolygonStr "polygon"
#define kpolygonToolStr "polygonTool"
#define kpolySelToolStr "polySelTool"
#define kpondRipplesStr "pondRipples"
#define kpositionStr "position"
#define kpostScriptColorStr "postScriptColor"
#define kposterEdgesStr "posterEdges"
#define kposterizationStr "posterization"
#define kposterizeStr "posterize"
#define kpreciseStr "precise"
#define kpreciseMatteStr "preciseMatte"
#define kpredefinedColorsStr "predefinedColors"
#define kpreferBuiltinStr "preferBuiltin"
#define kpreferencesClassStr "preferencesClass"
#define kpreferencesStr "preferences"
#define kpreserveStr "preserve"
#define kpreserveAdditionalStr "preserveAdditional"
#define kpreserveLuminosityStr "preserveLuminosity"
#define kpreserveTransparencyStr "preserveTransparency"
#define kpresetManagerCommandStr "presetManager"
#define kpressureStr "pressure"
#define kpreviewStr "preview"
#define kpreviewBlackStr "previewBlack"
#define kpreviewCMYStr "previewCMY"
#define kpreviewCMYKEnumStr "previewCMYKEnum"
#define kpreviewCMYKStr "previewCMYK"
#define kpreviewCMYKTypeStr "previewCMYKType"
#define kpreviewCyanStr "previewCyan"
#define kpreviewFullSizeStr "previewFullSize"
#define kpreviewIconStr "previewIcon"
#define kpreviewMacThumbnailStr "previewMacThumbnail"
#define kpreviewMagentaStr "previewMagenta"
#define kpreviewOffStr "previewOff"
#define kpreviewWinThumbnailStr "previewWinThumbnail"
#define kpreviewYellowStr "previewYellow"
#define kpreviewsQueryStr "previewsQuery"
#define kpreviousStr "previous"
#define kprimariesStr "primaries"
#define kprintOptionsStr "printOptions"
#define kprintStr "print"
#define kprintSettingsStr "printSettings"
#define kprintSizeStr "printSize"
#define kprintingInksSetupStr "printingInksSetup"
#define kprintResolutionStr "printerResolution"  // mscarafone 4/13/00
#define kprintToFitStr "printToFit" // mscarafone 4/19/00
#define kprocessSerialNumberStr "processSerialNumber"
#define kprofileStr "profile"
#define kprofileMismatchStr "profileMismatch"
#define kprofileSetupStr "profileSetup"
#define kprofileToProfileStr "profileToProfile"
#define kPromptedForColorSetup "promptedForColorSetup"
#define kproofBlackStr "proofBlack"
#define kproofCMYStr "proofCMY"
#define kproofCMYKStr "proofCMYK"
#define kproofCustomStr "proofCustom"
#define kproofCyanStr "proofCyan"
#define kproofInkBlackStr "proofInkBlack"
#define kproofMacintoshStr "proofMacintosh"
#define kproofMagentaStr "proofMagenta"
#define kproofMonitorStr "proofMonitor"
#define kproofPaperWhiteStr "proofPaperWhite"
#define kproofSetupStr "proofSetup"
#define kproofWindowsStr "proofWindows"
#define kproofYellowStr "proofYellow"
#define kpropertyStr "property"
#define kProtectNoneStr	"protectNone"
#define kProtectTransparencyStr "protectTransparency"
#define kProtectCompositeStr "protectComposite"
#define kProtectPositionStr "protectPosition"
#define kProtectAllStr "protectAll"
#define kprovinceStateStr "provinceState"
#define kpurgeStr "purge"
#define kpurgeItemStr "purgeItem"
#define kpurpleStr "purple"
#define kpyramidsStr "pyramids"
#define kQCSAverageStr "QCSAverage"
#define kQCSCorner0Str "QCSCorner0"
#define kQCSCorner1Str "QCSCorner1"
#define kQCSCorner2Str "QCSCorner2"
#define kQCSCorner3Str "QCSCorner3"
#define kQCSIndependentStr "QCSIndependent"
#define kQCSSide0Str "QCSSide0"
#define kQCSSide1Str "QCSSide1"
#define kQCSSide2Str "QCSSide2"
#define kQCSSide3Str "QCSSide3"
#define kQDRectangleStr "QDRectangle"
#define kquadCenterStateStr "quadCenterState"
#define kquadrilateralStr "quadrilateral"
#define kquadCorner0Str "quadCorner0"
#define kquadCorner1Str "quadCorner1"
#define kquadCorner2Str "quadCorner2"
#define kquadCorner3Str "quadCorner3"
#define kquadtoneStr "quadtone"
#define kqualityStr "quality"
#define kqueryAlwaysStr "queryAlways"
#define kqueryAskStr "queryAsk"
#define kqueryNeverStr "queryNever"
#define kqueryStateStr "queryState"
#define kquickMaskStr "quickMask"
#define kquitStr "quit"
#define kRGBStr "RGB"
#define kRGB48Str "RGB48"
#define kRGBBlendGammaStr "RGBBlendGamma"
#define kRGBColorStr "RGBColor"
#define kRGBColorModeStr "RGBColorMode"
#define kRGBSetupClassStr "RGBSetupClass"
#define kRGBSetupStr "RGBSetup"
#define kRGBSetupSourceStr "RGBSetupSource"
#define kRGBSpectrumStr "RGBSpectrum"
#define kradialStr "radial"
#define kradialBlurStr "radialBlur"
#define kradiusStr "radius"
#define krandomStr "random"
#define krandomSeedStr "randomSeed"
#define krangeStr "range"
#define krasterizeStr "rasterize"
#define krasterizeAllStr "rasterizeAll"
#define krasterizeItemStr "rasterizeItem"
#define krasterizeContentStr "rasterizeContent"
#define krasterizeShapeStr "rasterizeShape"
#define krasterizeLayerStr "rasterizeLayer"
#define krasterizeLinkedStr "rasterizeLinked"
#define krasterizeTypeLayerStr "rasterizeTypeLayer"
#define krasterizeVectorMaskStr "rasterizeVectorMask"
#define kratioStr "ratio"
#define krawDataStr "rawData"
#define krawFormatStr "rawFormat"
#define krecentFilesStr "recentFiles"
#define krect16Str "rect16"
#define krectToPolarStr "rectToPolar"
#define krectangleStr "rectangle"
#define krectangleToolStr "rectangleTool"
#define kroundedRectangleToolStr "roundedRectangleTool"
#define kredStr "red"
#define kredBlackPointStr "redBlackPoint"
#define kredGammaStr "redGamma"
#define kredoStr "redo"
#define kredoTypeStr "redoType"
#define kredWhitePointStr "redWhitePoint"
#define kredXStr "redX"
#define kredYStr "redY"
#define kredrawCompleteStr "redrawComplete"
#define kredsStr "reds"
#define kreflectedStr "reflected"
#define kregistrationMarksStr "registrationMarks"
#define krelativeStr "relative"
#define kreliefStr "relief"
#define kremoveBlackMatteStr "removeBlackMatte"
#define kremoveLayerMaskStr "removeLayerMask"
#define kremoveWhiteMatteStr "removeWhiteMatte"
#define krenameStr "rename"
#define krenderFidelityStr "renderFidelity"
#define krepeatStr "repeat"
#define krepeatEdgePixelsStr "repeatEdgePixels"
#define kreplaceColorStr "replaceColor"
#define kresampleStr "resample"
#define kresetStr "reset"
#define kresetPalettesStr "resetPalettes"
#define kresizeWindowsOnZoomStr "resizeWindowsOnZoom"
#define kresizeStr "resize"
#define kresolutionStr "resolution"
#define kresourceIDStr "resourceID"
#define kresponseStr "response"
#define kretainHeaderStr "retainHeader"
#define kreticulationStr "reticulation"
#define kreturnIDAttrStr "returnIDAttr"
#define krevealAllStr "revealAll"
#define krevealSelectionStr "revealSelection"
#define kreverseStr "reverse"
#define krevertStr "revert"
#define krightStr "right"
#define krippleStr "ripple"
#define krippleMagnitudeStr "rippleMagnitude"
#define krippleSizeStr "rippleSize"
#define krolloverStr "rollover"
#define krotateEventEnumStr "rotateEventEnum"
#define krotateStr "rotate"
#define krotoscopingPreferencesStr "rotoscopingPreferences"
#define kroughPastelsStr "roughPastels"
#define kroundStr "round"
#define kroundnessStr "roundness"
#define krulerCmStr "rulerCm"
#define krulerInchesStr "rulerInches"
#define krulerOriginHStr "rulerOriginH"
#define krulerOriginVStr "rulerOriginV"
#define krulerPercentStr "rulerPercent"
#define krulerPicasStr "rulerPicas"
#define krulerPixelsStr "rulerPixels"
#define krulerPointsStr "rulerPoints"
#define krulerUnitsStr "rulerUnits"
#define krulerMmStr "rulerMm"
#define ksInt16Str "sInt16"
#define ksInt32Str "sInt32"
#define ksInt64Str "sInt64"
#define ksMFloatStr "sMFloat"
#define ksMIntStr "sMInt"
#define kSMPTECStr "SMPTEC"
#define ksRGBStr "sRGB"
#define ksample3x3Str "sample3x3"
#define ksample5x5Str "sample5x5"
#define ksamplePointStr "samplePoint"
#define ksaturateStr "saturate"
#define ksaturationStr "saturation"
#define ksaturationToolStr "saturationTool"
#define ksaveStr "save"
#define ksaveAndCloseStr "saveAndClose"
#define ksaveCompositeStr "saveComposite"
#define ksaveForWebStr "saveForWeb"
#define ksavePaletteLocationsStr "savePaletteLocations"
#define ksavePathsStr "savePaths"
#define ksavePyramidsStr "savePyramids"
#define ksaveTransparencyStr "saveTransparency"
#define ksavedStr "saved"
#define ksavingStr "saving"
#define ksavingFilesPreferencesStr "savingFilesPreferences"
#define kscaleStr "scale"
#define kscaleHorizontalStr "scaleHorizontal"
#define kscaleVerticalStr "scaleVertical"
#define kscaleEffectsStr "scaleEffects"
#define kscaleEffectsEventStr "scaleEffectsEvent"
#define kscalingStr "scaling"
#define kscansStr "scans"
#define kscitexCTFormatStr "scitexCTFormat"
#define kscratchDisksStr "scratchDisks"
#define kscreenStr "screen"
#define kscreenCircleStr "screenCircle"
#define kscreenDotStr "screenDot"
#define kscreenFileStr "screenFile"
#define kscreenLineStr "screenLine"
#define kscreenTypeStr "screenType"
#define ksectionHStr "sectionH"
#define kselectStr "select"
#define kselectedItemsStr	"selectedItems"
#define kselectedAreasStr "selectedAreas"
#define kselectionStr "selection"
#define kselectionClassStr "selectionClass"
#define kselectionEnumStr "selectionEnum"
#define kselectiveStr "selective"
#define kselectiveColorStr "selectiveColor"
#define kseparationSetupStr "separationSetup"
#define kseparationTablesStr "separationTables"
#define kseparationsStr "separations"
#define kserialStringStr "serialString"
#define ksessionIDStr "sessionID"
#define ksetStr "set"
#define kshadingIntensityStr "shadingIntensity"
#define kshadingNoiseStr "shadingNoise"
#define kshadingShapeStr "shadingShape"
#define kshadowColorStr "shadowColor"
#define kshadowIntensityStr "shadowIntensity"
#define kshadowLevelsStr "shadowLevels"
#define kshadowModeStr "shadowMode"
#define kshadowOpacityStr "shadowOpacity"
#define kshadowsStr "shadows"
#define kshallowStr "shallow"
#define kshapeStr "shape"
#define kshapeClassStr "shapeClass"
#define kshapeburstStr "shapeburst"
#define kshapeOperationStr "shapeOperation"
#define ksharpenStr "sharpen"
#define ksharpenEdgesStr "sharpenEdges"
#define ksharpenMoreStr "sharpenMore"
#define ksharpenToolStr "sharpenTool"
#define ksharpnessStr "sharpness"
#define kshearStr "shear"
#define kshearEdStr "shearEd"
#define kshearPointsStr "shearPoints"
#define kshearStStr "shearSt"
#define kshiftKeyStr "shiftKey"
#define kshiftKeyToolSwitchStr "shiftKeyToolSwitch"
#define kshortFloatStr "shortFloat"
#define kshortIntegerStr "shortInteger"
#define kshortLinesStr "shortLines"
#define kshortNamesStr "shortNames"
#define kshortStrokesStr "shortStrokes"
#define kshowBBoxStr "showBBox" // mscarafone 4/19/00
#define kshowMoreOptions "showMoreOptions" //mscarafone 4/19/00
#define kshowStr "show"
#define kshowAllStr "showAll"
#define kshowCJKFeaturesStr "showCJKFeatures"
#define kshowEnglishFontNamesStr "showEnglishFontNames"
#define kshowNoneStr "showNone"
#define kshowToolTipsStr "showToolTips"
#define kshowTransparencyStr "showTransparency"
#define ksidesStr "sides"
#define ksimilarStr "similar"
#define ksingle72ColorStr "single72Color"
#define ksingle72GrayStr "single72Gray"
#define ksingleColumnStr "singleColumn"
#define ksingleNoCompositePSStr "singleNoCompositePS"
#define ksingleRowStr "singleRow"
#define ksizeStr "size"
#define kskewStr "skew"
#define ksliceImageTypeStr "sliceImageType"
#define ksliceFromLayerStr "sliceFromLayer"
#define ksliceSelectToolStr "sliceSelectTool"
#define ksliceStr "slice"
#define ksliceToolStr "sliceTool"
#define ksliceTypeStr "sliceType"
#define kslopeLimitMatteStr "slopeLimitMatte"
#define ksmallStr "small"
#define ksmartBlurStr "smartBlur"
#define ksmartBlurModeStr "smartBlurMode"
#define ksmartBlurModeEdgeOnlyStr "smartBlurModeEdgeOnly"
#define ksmartBlurModeNormalStr "smartBlurModeNormal"
#define ksmartBlurModeOverlayEdgeStr "smartBlurModeOverlayEdge"
#define ksmartBlurQualityStr "smartBlurQuality"
#define ksmartBlurQualityHighStr "smartBlurQualityHigh"
#define ksmartBlurQualityLowStr "smartBlurQualityLow"
#define ksmartBlurQualityMediumStr "smartBlurQualityMedium"
#define ksmoothStr "smooth"
#define ksmoothCornersStr "smoothCorners"
#define ksmoothIndentsStr "smoothIndents"
#define ksmoothnessStr "smoothness"
#define ksmudgeStickStr "smudgeStick"
#define ksmudgeToolStr "smudgeTool"
#define ksnapStr "snap"
#define ksnapAllStr "snapAll"
#define ksnapshotClassStr "snapshotClass"
#define ksnapshotEnumStr "snapshotEnum"
#define ksnapshotInitialStr "snapshotInitial"
#define ksnapNoneStr "snapNone"
#define ksnapToDocBoundsStr "snapToDocBounds"
#define ksnapToGuidesStr "snapToGuides"
#define ksnapToGridStr "snapToGrid"
#define ksnapToLayerBoundsStr "snapToLayerBounds"
#define ksnapToSlicesStr "snapToSlices"
#define ksoftLightStr "softLight"
#define ksoftMatteStr "softMatte"
#define ksoftnessStr "softness"
#define ksolarizeStr "solarize"
#define ksolidColorStr "solidColor"
#define ksolidColorLayerStr "solidColorLayer"
#define ksolidFillStr "solidFill"
#define ksoundAnnotToolStr "soundAnnotTool"
#define ksourceFolderStr "sourceFolder"
#define ksourceImportStr "sourceImport"
#define ksourceOpenFilesStr "sourceOpenFiles"
#define ksourceStr "source"
#define ksource2Str "source2"
#define ksourceModeStr "sourceMode"
#define ksourceModeTypeStr "sourceModeType"
#define kspacingStr "spacing"
#define kspatterStr "spatter"
#define kspecialInstructionsStr "specialInstructions"
#define kspectrumStr "spectrum"
#define kspherizeStr "spherize"
#define kspherizeModeStr "spherizeMode"
#define kspinStr "spin"
#define ksplitChannelsStr "splitChannels"
#define kspongeStr "sponge"
#define kspotStr "spot"
#define kspotColorStr "spotColor"
#define kspotColorChannelStr "spotColorChannel"
#define ksprayRadiusStr "sprayRadius"
#define ksprayedStrokesStr "sprayedStrokes"
#define ksquareStr "square"
#define ksquareSizeStr "squareSize"
#define ksrcBlackMaxStr "srcBlackMax"
#define ksrcBlackMinStr "srcBlackMin"
#define ksrcWhiteMaxStr "srcWhiteMax"
#define ksrcWhiteMinStr "srcWhiteMin"
#define kstaggerStr "stagger"
#define kstainedGlassStr "stainedGlass"
#define kstampStr "stamp"
#define kstampInStr "stampIn"
#define kstampOutStr "stampOut"
#define kstandardStr "standard"
#define kstarStr "star"
#define kstartStr "start"
#define kstartArrowheadStr "startArrowhead"
#define kstateStr "state"
#define kstepByStepStr "stepByStep"
#define kstdAStr "stdA"
#define kstdBStr "stdB"
#define kstdCStr "stdC"
#define kstdEStr "stdE"
#define kstopStr "stop"
#define kstrengthStr "strength"
#define kstrengthPluginStr "strengthPlugin"
#define kstrengthRatioStr "strengthRatio"
#define kstretchToFitStr "stretchToFit"
#define kstringChannelStr "stringChannel"
#define kstringClassFormatStr "stringClassFormat"
#define kstringCompensationStr "stringCompensation"
#define kstringFSSStr "stringFSS"
#define kstringIntegerStr "stringInteger"
#define kstrokeStr "stroke"
#define kstrokeColorStr "strokeColor"
#define kstrokeDetailStr "strokeDetail"
#define kstrokeDirHorizontalStr "strokeDirHorizontal"
#define kstrokeDirLeftDiagStr "strokeDirLeftDiag"
#define kstrokeDirRightDiagStr "strokeDirRightDiag"
#define kstrokeDirVerticalStr "strokeDirVertical"
#define kstrokeDirectionStr "strokeDirection"
#define kstrokeDirectionTypeStr "strokeDirectionType"
#define kstrokeEmbossStr "strokeEmboss"
#define kstrokeLengthStr "strokeLength"
#define kstrokeLocationStr "strokeLocation"
#define kstrokePressureStr "strokePressure"
#define kstrokeSizeStr "strokeSize"
#define kstrokeWidthStr "strokeWidth"
#define kstyleClassStr "styleClass"
#define kstyleStr "style"
#define kstylesStr "styles"
#define kstylesAppendStr "stylesAppend"
#define kstylesDeleteStr "stylesDelete"
#define kstylesLoadStr "stylesLoad"
#define kstylesNewStr "stylesNew"
#define kstylesResetStr "stylesReset"
#define kstylesSaveStr "stylesSave"
#define kstylesTextViewStr	"stylesTextView"
#define kstylesThumbnailViewStr	"stylesThumbnailView"
#define kstylesTextThumbnailViewStr	"stylesTextThumbnailView"
#define kstylesSmallThumbnailViewStr	"stylesSmallThumbnailView"
#define kstylesSmallTextViewStr	"stylesSmallTextView"
#define kstylesDetailViewStr	"stylesDetailView"
#define kstylusIsColorStr "stylusIsColor"
#define kstylusIsOpacityStr "stylusIsOpacity"
#define kstylusIsPressureStr "stylusIsPressure"
#define kstylusIsSizeStr "stylusIsSize"
#define ksubpathStr "subpath"
#define ksubpathListKeyStr "subpathListKey"
#define ksubpathsListStr "subpathsList"
#define ksubtractStr "subtract"
#define ksubtractFromStr "subtractFrom"
#define ksumieStr "sumie"
#define ksupplementalCategoriesStr "supplementalCategories"
#define ksuppressWarningsStr "suppressWarnings"
#define kswatchesAppendStr "swatchesAppend"
#define kswatchesNewStr "swatchesNew"
#define kswatchesReplaceStr "swatchesReplace"
#define kswatchesResetStr "swatchesReset"
#define kswatchesSaveStr "swatchesSave"
#define kswatchesThumbnailViewStr "swatchesThumbnailView"
#define kswatchesTextThumbnailViewStr "swatchesTextThumbnailView"
#define ksystemCMYKStr "systemCMYK"
#define ksystemGrayStr "systemGray"
#define ksystemInfoStr "systemInfo"
#define ksystemPaletteStr "systemPalette"
#define ksystemPickerStr "systemPicker"
#define ksystemRGBStr "systemRGB"
#define kTIFFStr "TIFF"
#define kTIFFFormatStr "TIFFFormat"
#define ktablesStr "tables"
#define ktakeMergedSnapshotStr "takeMergedSnapshot"
#define ktakeSnapshotStr "takeSnapshot"
#define ktargaFormatStr "targaFormat"
#define ktargetEnumStr "targetEnum"
#define ktargetStr "target"
#define ktargetIDStr "targetID"
#define ktargetPathStr "targetPath"
#define ktargetPathIndexStr "targetPathIndex"
#define ktexTypeBlocksStr "texTypeBlocks"
#define ktexTypeBrickStr "texTypeBrick"
#define ktexTypeBurlapStr "texTypeBurlap"
#define ktexTypeCanvasStr "texTypeCanvas"
#define ktexTypeFrostedStr "texTypeFrosted"
#define ktexTypeSandstoneStr "texTypeSandstone"
#define ktexTypeTinyLensStr "texTypeTinyLens"
#define ktextAnnotToolStr "textAnnotTool"
#define ktextTypeStr "textType"
#define ktextKeyStr "textKey"
#define ktextClickPointStr "textClickPoint"
#define ktextDataStr "textData"
#define ktextLayerStr "textLayer"
#define ktextStyleStr "textStyle"
#define ktextStyleRangeStr "textStyleRange"
#define ktextureStr "texture"
#define ktextureCoverageStr "textureCoverage"
#define ktextureDepthStr "textureDepth"
#define ktextureFileStr "textureFile"
#define ktextureFillStr "textureFill"
#define ktextureTypeStr "textureType"
#define ktexturizerStr "texturizer"
#define kthreeDigitStr "threeDigit"
#define kthresholdStr "threshold"
#define kthresholdEnumStr "thresholdEnum"
#define kthresholdClassEventStr "thresholdClassEvent"
#define kthumbnailStr "thumbnail"
#define ktileStr "tile"
#define ktileNumberStr "tileNumber"
#define ktileOffsetStr "tileOffset"
#define ktileSizeStr "tileSize"
#define ktilePluginStr "tilePlugin"
#define ktilesStr "tiles"
#define ktimeoutAttrStr "timeoutAttr"
#define ktitleStr "title"
#define ktoStr "to"
#define ktoBuiltinStr "toBuiltin"
#define ktoLinkedStr "toLinked"
#define ktoModeStr "toMode"
#define ktoggleActionsPaletteStr "toggleActionsPalette"
#define ktoggleAnnotsStr "toggleAnnots"
#define ktoggleBlackPreviewStr "toggleBlackPreview"
#define ktoggleBrushesPaletteStr "toggleBrushesPalette"
#define ktoggleCMYKPreviewStr "toggleCMYKPreview"
#define ktoggleCMYPreviewStr "toggleCMYPreview"
#define ktoggleChannelsPaletteStr "toggleChannelsPalette"
#define ktoggleColorPaletteStr "toggleColorPalette"
#define ktoggleCyanPreviewStr "toggleCyanPreview"
#define ktoggleEdgesStr "toggleEdges"
#define ktoggleGamutWarningStr "toggleGamutWarning"
#define ktoggleGridStr "toggleGrid"
#define ktoggleGuidesStr "toggleGuides"
#define ktoggleHistoryPaletteStr "toggleHistoryPalette"
#define ktoggleInfoPaletteStr "toggleInfoPalette"
#define ktoggleLayerMaskStr "toggleLayerMask"
#define ktoggleLayersPaletteStr "toggleLayersPalette"
#define ktoggleLockGuidesStr "toggleLockGuides"
#define ktoggleLockSlicesStr "toggleLockSlices"
#define ktoggleMagentaPreviewStr "toggleMagentaPreview"
#define ktoggleNavigatorPaletteStr "toggleNavigatorPalette"
#define ktoggleOptionsPaletteStr "toggleOptionsPalette"
#define ktoggleOthersStr "toggleOthers"
#define ktogglePathsStr "togglePaths"
#define ktogglePathsPaletteStr "togglePathsPalette"
#define ktoggleProofColorsStr "toggleProofColors"
#define ktoggleRGBMacPreviewStr "toggleRGBMacPreview"
#define ktoggleRGBUncompensatedPreviewStr "toggleRGBUncompensatedPreview"
#define ktoggleRGBWindowsPreviewStr "toggleRGBWindowsPreview"
#define ktoggleRulersStr "toggleRulers"
#define ktoggleShowExtrasStr "toggleShowExtras"
#define ktoggleSlicesStr "toggleSlices"
#define ktoggleSnapToGridStr "toggleSnapToGrid"
#define ktoggleSnapToGuidesStr "toggleSnapToGuides"
#define ktoggleStatusBarStr "toggleStatusBar"
#define ktoggleStylesPaletteStr "toggleStylesPalette"
#define ktoggleTextLayerTypeStr "toggleTextLayerType"
#define ktoggleSwatchesPaletteStr "toggleSwatchesPalette"
#define ktoggleToolsPaletteStr "toggleToolsPalette"
#define ktoggleVectorMaskStr "toggleVectorMask"
#define ktoggleYellowPreviewStr "toggleYellowPreview"
#define ktoleranceStr "tolerance"
#define ktoolStr "tool"
#define ktopStr "top"
#define ktopLeftPixelColorStr "topLeftPixelColor"
#define ktornEdgesStr "tornEdges"
#define ktotalLimitStr "totalLimit"
#define ktraceContourStr "traceContour"
#define ktrackingStr "tracking"
#define ktransactionIDAttrStr "transactionIDAttr"
#define ktransferFunctionStr "transferFunction"
#define ktransferPointStr "transferPoint"
#define ktransferSpecClassStr "transferSpecClass"
#define ktransferSpecStr "transferSpec"
#define ktransformStr "transform"
#define ktransparencyEnumStr "transparencyEnum"
#define ktransparencyStr "transparency"
#define ktransparencyGamutPreferencesStr "transparencyGamutPreferences"
#define ktransparencyGridStr "transparencyGrid"
#define ktransparencyGridColorsTypeStr "transparencyGridColorsType"
#define ktransparencyGridColorsStr "transparencyGridColors"
#define ktransparencyGridSizeStr "transparencyGridSize"
#define ktransparencyPrefsStr "transparencyPrefs"
#define ktransparencyShapeStr "transparencyShape"
#define ktransparencyStopStr "transparencyStop"
#define ktransparentStr "transparent"
#define ktransparentIndexStr "transparentIndex"
#define ktransparentWhitesStr "transparentWhites"
#define ktrapStr "trap"
#define ktrimStr "trim"
#define ktrimBasedOnStr "trimBasedOn"
#define ktrinitronStr "trinitron"
#define ktritoneStr "tritone"
#define ktrueStr "true"
#define ktwirlStr "twirl"
#define ktwistStr "twist"
#define ktwoDigitStr "twoDigit"
#define ktypeStr "type"
#define ktypeClassModeOrClassModeStr "typeClassModeOrClassMode"
#define ktypeCreateOrEditToolStr "typeCreateOrEditTool"
#define kUCAStr "UCA"
#define kuIBitmapStr "uIBitmap"
#define kuICMYKStr "uICMYK"
#define kuIDuotoneStr "uIDuotone"
#define kuIGrayscaleStr "uIGrayscale"
#define kuIIndexedStr "uIIndexed"
#define kuILabStr "uILab"
#define kuIMultichannelStr "uIMultichannel"
#define kuIRGBStr "uIRGB"
#define kuInt32Str "uInt32"
#define kURLStr "URL"
#define kundefinedAreaStr "undefinedArea"
#define kunderlineStr "underline"
#define kunderpaintingStr "underpainting"
#define kundoEventStr "undoEvent"
#define kundoEnumStr "undoEnum"
#define kungroupStr "ungroup"
#define kuniformStr "uniform"
#define kuniformDistributionStr "uniformDistribution"
#define kunitsPrefsStr "unitsPrefs"
#define kunitsRulersPreferencesStr "unitsRulersPreferences"
#define kunixStr "unix"
#define kunlinkStr "unlink"
#define kunsharpMaskStr "unsharpMask"
#define kunspecifiedColorStr "unspecifiedColor"
#define kuntitledStr "untitled"
#define kupperCaseSerialStr "upperCaseSerial"
#define kupperStr "upper"
#define kupperCaseStr "upperCase"
#define kupperCaseExtensionStr "upperCaseExtension"
#define kupperYStr "upperY"
#define kurgencyStr "urgency"
#define kuseAccurateScreensStr "useAccurateScreens"
#define kuseAdditionalPluginsStr "useAdditionalPlugins"
#define kuseCacheForHistogramsStr "useCacheForHistograms"
#define kuseCurvesStr "useCurves"
#define kuseDefaultStr "useDefault"
#define kuseGlobalAngleStr "useGlobalAngle"
#define kuseICCProfileStr "useICCProfile"
#define kuseMaskStr "useMask"
#define kuserDefinedStr	"userDefined"
#define kuseShapeStr "useShape"
#define kuseTextureStr "useTexture"
#define kuseTextOutlinesStr "useTextOutlines"
#define kuserMaskEnabledStr "userMaskEnabled"
#define kuserMaskLinkedStr "userMaskLinked"
#define kuserMaskOptionsStr "userMaskOptions"
#define kuserStopStr "userStop"
#define kuserStr "user"
#define kusingStr "using"
#define kvMPreferencesStr "vMPreferences"
#define kvalueStr "value"
#define kvalueListStr "valueList"
#define kvariationsStr "variations"
#define kvector0Str "vector0"
#define kvector1Str "vector1"
#define kvectorColorStr "vectorColor"
#define kvectorMaskCurrentPathStr "vectorMaskCurrentPath"
#define kvectorMaskEnabledStr "vectorMaskEnabled"
#define kvectorMaskHideAllStr "vectorMaskHideAll"
#define kvectorMaskLinkedStr "vectorMaskLinked"
#define kvectorMaskRevealAllStr "vectorMaskRevealAll"
#define kvectorMaskStr "vectorMask"
#define kversionStr "version"
#define kversionFixStr "versionFix"
#define kversionMajorStr "versionMajor"
#define kversionMinorStr "versionMinor"
#define kverticalStr "vertical"
#define kverticalLocationStr "verticalLocation"
#define kverticalOnlyStr "verticalOnly"
#define kverticalScaleStr "verticalScale"
#define kvideoAlphaStr "videoAlpha"
#define kvioletStr "violet"
#define kvisibleStr "visible"
#define kwaitStr "wait"
#define kwarpStr "warp"
#define kwarpArchStr "warpArch"
#define kwarpArcStr "warpArc"
#define kwarpArcLowerStr "warpArcLower"
#define kwarpArcUpperStr "warpArcUpper"
#define kwarpBulgeStr "warpBulge"
#define kwarpFlagStr "warpFlag"
#define kwarpFishStr "warpFish"
#define kwarpFisheyeStr "warpFisheye"
#define kwarpInflateStr "warpInflate"
#define kwarpNoneStr "warpNone"
#define kwarpRiseStr "warpRise"
#define kwarpStyleStr "warpStyle"
#define kwarpValueStr "warpValue"
#define kwarpPerspectiveStr "warpPerspective"
#define kwarpPerspectiveOtherStr "warpPerspectiveOther"
#define kwarpRotateStr "warpRotate"
#define kwarpShellLowerStr "warpShellLower"
#define kwarpShellUpperStr "warpShellUpper"
#define kwarpSqueezeStr "warpSqueeze"
#define kwarpTwistStr "warpTwist"
#define kwarpWaveStr "warpWave"
#define kwatchSuspensionStr "watchSuspension"
#define kwaterPaperStr "waterPaper"
#define kwatercolorStr "watercolor"
#define kwatermarkStr "watermark"
#define kwaveStr "wave"
#define kwaveSineStr "waveSine"
#define kwaveSquareStr "waveSquare"
#define kwaveTriangleStr "waveTriangle"
#define kwaveTypeStr "waveType"
#define kwavelengthMaxStr "wavelengthMax"
#define kwavelengthMinStr "wavelengthMin"
#define kwebSafeRampStr "webSafeRamp"
#define kwebStr "web"
#define kwetEdgesStr "wetEdges"
#define kwhatStr "what"
#define kwhichEffectStr "whichEffect"
#define kwhichEffectTypeStr "whichEffectType"
#define kwhiteStr "white"
#define kwhiteClipStr "whiteClip"
#define kwhiteIntensityStr "whiteIntensity"
#define kwhiteIsHighStr "whiteIsHigh"
#define kwhiteLevelStr "whiteLevel"
#define kwhitePointStr "whitePoint"
#define kwhitesStr "whites"
#define kwholePathStr "wholePath"
#define kwideGamutRGBStr "wideGamutRGB"
#define kwidePhosphorsStr "widePhosphors"
#define kwidthStr "width"
#define kwildCardStr "wildCard"
#define kwinThumbnailStr "winThumbnail"
#define kwindStr "wind"
#define kwindingFillStr "windingFill"
#define kwindMethodStr "windMethod"
#define kwindowsStr "windows"
#define kwindowsSystemStr "windowsSystem"
#define kwithStr "with"
#if qWorkflow
#define kcheckInStr "checkIn"
#define kcheckOutStr "checkOut"
#define kundoCheckOutStr "undoCheckOut"
#define kuploadToServerStr "uploadToServer"
#define kdownloadFromServerStr "downloadFromServer"
#define kacceleratedStr "accelerated"
#define kaddToWorkflowStr "addToWorkflow"
#define kworkflowOptionsStr "workflowOptions"
#if GENERIC_WEBDAV
#define kopenFromWorkflowStr "openFromWorkflow"
#endif
#endif
#define kworkPathStr "workPath"
#define kworkPathIndexStr "workPathIndex"
#define kwrapStr "wrap"
#define kwrapAroundStr "wrapAround"
#define kxStr "x"
#define kxorStr "xor"
#define kxYYColorStr "xYYColor"
#define kyStr "y"
#define kyellowStr "yellow"
#define kyellowColorStr "yellowColor"
#define kyellowsStr "yellows"
#define kyesStr "yes"
#define kyesNoStr "yesNo"
#define kyyddmmStr "yyddmm"
#define kyymmddStr "yymmdd"
#define kyyyymmddStr "yyyymmdd"
#define kzigZagStr "zigZag"
#define kzigZagTypeStr "zigZagType"
#define kzipStr "zip"
#define kzoomStr "zoom"
#define kzoomInStr "zoomIn"
#define kzoomOutStr "zoomOut"
#define kzoomToolStr "zoomTool"
#define kreplaceExistingStr "replaceExisting"
#define kvectorDataStr "vectorData"

// Text is, uh, complicated...
#define kallCapsStr "allCaps"
#define kautoLeadingStr "autoLeading"
#define kautoLeadingPercentageStr "autoLeadingPercentage"
#define kbaseStr "base"
#define kbaselineDirectionStr "baselineDirection"
#define kbaselineStr "baseline"
#define kboldStr "bold"
#define kbolditalicStr "bolditalic"
#define kboundsStr "bounds"
#define kboxStr "box"
#define kburasagariStr "burasagari"
#define kdefaultStyleStr "defaultStyle"
#define kendIndentStr "endIndent"
#define kfirstLineIndentStr "firstLineIndent"
#define kfontCapsStr "fontCaps"
#define kfontPostScriptNameStr "fontPostScriptName"
#define kgridAlignmentStr "gridAlignment"
#define khangingRomanStr "hangingRoman"
#define khyphenateCapitalizedStr "hyphenateCapitalized"
#define khyphenateLimitStr "hyphenateLimit"
#define khyphenatePostLengthStr "hyphenatePostLength"
#define khyphenatePreLengthStr "hyphenatePreLength"
#define khyphenateStr "hyphenate"
#define khyphenateWordSizeStr "hyphenateWordSize"
#define khyphenationLanguageStr "hyphenationLanguage"
#define khyphenationZoneStr "hyphenationZone"
#define kicfbottomStr "icfbottom"
#define kicftopStr "icftop"
#define kinAPathStr "inAPath"
#define kitalicStr "italic"
#define kjapaneseStr "japanese"
#define kjustificationGlyphDesiredStr "justificationGlyphDesired"
#define kjustificationGlyphMaximumStr "justificationGlyphMaximum"
#define kjustificationGlyphMinimumStr "justificationGlyphMinimum"
#define kjustificationLetterDesiredStr "justificationLetterDesired"
#define kjustificationLetterMaximumStr "justificationLetterMaximum"
#define kjustificationLetterMinimumStr "justificationLetterMinimum"
#define kjustificationWordDesiredStr "justificationWordDesired"
#define kjustificationWordMaximumStr "justificationWordMaximum"
#define kjustificationWordMinimumStr "justificationWordMinimum"
#define kjustifyCenterStr "justifyCenter"
#define kjustifyLeftStr "justifyLeft"
#define kjustifyRightStr "justifyRight"
#define kkinsokuSetNameStr "kinsokuSetName"
#define kleadingAboveStr "leadingAbove"
#define kleadingBelowStr "leadingBelow"
#define kleadingTypeStr "leadingType"
#define kligatureStr "ligature"
#define kmojiKumiNameStr "mojiKumiName"
#define kmojiZumeStr "mojiZume"
#define knoBreakStr "noBreak"
#define koldStyleStr "oldStyle"
#define konACurveStr "onACurve"
#define kparagraphStyleRangeStr "paragraphStyleRange"
#define kparagraphStyleStr "paragraphStyle"
#define kpreferredKinsokuOrderStr "preferredKinsokuOrder"
#define kproportionalNumbersStr "proportionalNumbers"
#define kpushInStr "pushIn"
#define kpushOutStr "pushOut"
#define krectStr "rect"
#define kromanStr "roman"
#define ksmallCapsStr "smallCaps"
#define kspaceAfterStr "spaceAfter"
#define kspaceBeforeStr "spaceBefore"
#define kstartIndentStr "startIndent"
#define kstrikethroughStr "strikethrough"
#define ksubScriptStr "subScript"
#define ksubstitutesUsedStr "substitutesUsed"
#define ksuperScriptStr "superScript"
#define ksyntheticBoldStr "syntheticBold"
#define ksyntheticItalicStr "syntheticItalic"
#define ksyntheticStyleStr "syntheticStyle"
#define ksystemMetricsStr "systemMetrics"
#define ktextAllCapsStr "textAllCaps"
#define ktextBurasagariStr "textBurasagari"
#define ktextEveryLineComposerStr "textEveryLineComposer"
#define ktextFauxBoldStr "textFauxBold"
#define ktextFauxItalicStr "textFauxItalic"
#define ktextFractionalWidthsStr "textFractionalWidths"
#define ktextGriddingStr "textGridding"
#define ktextHyphenationStr "textHyphenation"
#define ktextJustificationStr "textJustification"
#define ktextLigaturesStr "textLigatures"
#define ktextNewTextMode "textNewTextMode"
#define ktextNewTextOrientation "textNewTextOrientation"
#define ktextNoBreakStr "textNoBreak"
#define ktextOidashiStr "textOidashi"
#define ktextOikomiStr "textOikomi"
#define ktextOldStyleStr "textOldStyle"
#define ktextParagraphStr "textParagraph"
#define ktextRotateHankakuStr "textRotateHankaku"
#define ktextShapeStr "textShape"
#define ktextSingleLineComposerStr "textSingleLineComposer"
#define ktextSmallCapsStr "textSmallCaps"
#define ktextStr "text"
#define ktextStrikethroughStr "textStrikethrough"
#define ktextSubscriptStr "textSubscript"
#define ktextSuperscriptStr "textSuperscript"
#define ktextTateChuuYokoStr "textTateChuuYoko"
#define ktextToolOptions "textToolOptions"
#define ktextUnderlineStr "textUnderline"
#define ktoggleCharacterPaletteStr "toggleCharacterPalette"
#define ktoggleParagraphPaletteStr "toggleParagraphPalette"
#define ktsumeStr "tsume"
#define ktxStr "tx"
#define ktyStr "ty"
#define ktypeUnitsStr "typeUnits"
#define kverticalUnderlineLeftStr "verticalUnderlineLeft"
#define kverticalUnderlinePostionStr "verticalUnderlinePosition"
#define kverticalUnderlineRightStr "verticalUnderlineRight"
#define kwariChuCountStr "wariChuCount"
#define kwariChuOrphanStr "wariChuOrphan"
#define kwariChuScaleStr "wariChuScale"
#define kwariChuWidowStr "wariChuWidow"
#define kwithStreamStr "withStream"
#define kworkingCMYKStr "workingCMYK"
#define kworkingGrayStr "workingGray"
#define kworkingRGBStr "workingRGB"
#define kworkingSpaceCodeStr "workingSpaceCode"
#define kworkingSpotStr "workingSpot"
#define kxxStr "xx"
#define kxyStr "xy"
#define kyxStr "yx"
#define kyyStr "yy"
#define kpointsUnitStr "pointsUnit"
#define kmillimetersUnitStr "millimetersUnit"

#define kupdateLayoutsStr "updateLayouts"
#define kreplaceSubstitutesStr "replaceSubstitutes"

// Hyphenation languages
#define	kenglishLanguageStr "englishLanguage"
#define	kfinnishLanguageStr "finnishLanguage"
#define	kstandardFrenchLanguageStr "standardFrenchLanguage"
#define	kcanadianFrenchLanguageStr "canadianFrenchLanguage"
#define	kstandardGermanLanguageStr "standardGermanLanguage"
#define	koldGermanLanguageStr "oldGermanLanguage"
#define	kswissGermanLanguageStr "swissGermanLanguage"
#define	kitalianLanguageStr "italianLanguage"
#define	kbokmalNorwegianLanguageStr "bokmalNorwegianLanguage"
#define	knynorskNorwegianLanguageStr "nynorskNorwegianLanguage"
#define	kstandardPortugueseLanguageStr "standardPortugueseLanguage"
#define	kbrazillianPortugueseLanguageStr "brazillianPortugueseLanguage"
#define	kspanishLanguageStr "spanishLanguage"
#define	kswedishLanguageStr "swedishLanguage"

//*****************************************************************************

#endif

